

<?php $__env->startSection('title', 'Support Tickets'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-primary fw-bold">
            <i class="fas fa-life-ring me-2"></i> My Support Tickets
        </h2>
        <a href="<?php echo e(route('user.support.create')); ?>" class="btn btn-gradient-primary shadow-sm rounded-pill px-4">
            <i class="fas fa-plus me-2"></i> New Ticket
        </a>
    </div>

    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="m-0"><i class="fas fa-ticket-alt me-2"></i> Tickets</h5>
            <form class="d-flex" method="GET" action="<?php echo e(route('user.support.index')); ?>">
                <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Search tickets..." value="<?php echo e(request('search')); ?>">
                <button type="submit" class="btn btn-light btn-sm">
                    <i class="fas fa-search"></i>
                </button>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="fw-bold text-primary">#<?php echo e($ticket->id); ?></td>
                                <td><?php echo e($ticket->subject); ?></td>
                                <td>
                                    <span class="badge 
                                        <?php if($ticket->status == 'open'): ?> bg-primary 
                                        <?php elseif($ticket->status == 'in_progress'): ?> bg-warning text-dark 
                                        <?php elseif($ticket->status == 'completed'): ?> bg-success 
                                        <?php elseif($ticket->status == 'closed'): ?> bg-danger 
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $ticket->status))); ?>

                                    </span>
                                </td>
                                <td><?php echo e($ticket->created_at->format('d M Y, H:i')); ?></td>
                                <td class="text-center">
                                    <a href="<?php echo e(route('user.support.show', $ticket->id)); ?>" class="btn btn-sm btn-info shadow-sm rounded-pill px-3">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    <i class="fas fa-info-circle me-2"></i> No support tickets found.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($tickets->hasPages()): ?>
                <div class="mt-3 d-flex justify-content-end">
                    <?php echo e($tickets->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
/* General Styles */
.container {
    max-width: 1200px;
}

/* Table Styling */
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.1);
}
.table th, .table td {
    vertical-align: middle;
}
.badge {
    font-size: 0.85rem;
    padding: 6px 12px;
    font-weight: 600;
    text-transform: capitalize;
}

/* Buttons */
.btn-gradient-primary {
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: #fff;
    border: none;
    transition: all 0.3s ease-in-out;
}
.btn-gradient-primary:hover {
    background: linear-gradient(135deg, #0056b3, #003f7f);
    color: #fff;
}

/* Responsive Design */
@media (max-width: 768px) {
    .table th, .table td {
        font-size: 0.85rem;
    }
    .btn-gradient-primary {
        font-size: 0.85rem;
        padding: 6px 10px;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\support\index.blade.php ENDPATH**/ ?>