

<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4">MT5 API Settings</h1>

    <!-- Success Message -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- API Settings Form -->
    <form action="<?php echo e(route('admin.mt5.api.setting.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <!-- Server Type -->
        <div class="mb-3">
            <label for="server_type" class="form-label">Server Type</label>
            <select name="server_type" id="server_type" class="form-select">
                <option value="real" <?php echo e(old('server_type', $settings->where('server_type', 'real')->first()?->server_type) === 'real' ? 'selected' : ''); ?>>Real</option>
                <option value="demo" <?php echo e(old('server_type', $settings->where('server_type', 'demo')->first()?->server_type) === 'demo' ? 'selected' : ''); ?>>Demo</option>
            </select>
        </div>

        <!-- API URL -->
        <div class="mb-3">
            <label for="api_url" class="form-label">API URL</label>
            <input type="url" name="api_url" id="api_url" class="form-control" value="<?php echo e(old('api_url', $settings->where('server_type', 'real')->first()?->api_url)); ?>" required>
        </div>

        <!-- API Key -->
        <div class="mb-3">
            <label for="api_key" class="form-label">API Key</label>
            <input type="text" name="api_key" id="api_key" class="form-control" value="<?php echo e(old('api_key', $settings->where('server_type', 'real')->first()?->api_key)); ?>" required>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">Update Settings</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\mt5_api_setting.blade.php ENDPATH**/ ?>