

<?php $__env->startSection('title', 'Payment Gateway Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-cogs me-2"></i> Payment Gateway Settings
        </h1>
        <div>
            <button class="btn btn-outline-primary btn-sm shadow-sm me-2" onclick="location.reload();">
                <i class="fas fa-sync-alt"></i> Refresh
            </button>
            <!-- Add Manual Gateway Button -->
            <a href="<?php echo e(route('admin.payment-gateways.createManual')); ?>" class="btn btn-warning btn-sm shadow-sm me-2">
                <i class="fas fa-wallet"></i> Add Manual Gateway
            </a>
            <!-- Add New Gateway Button -->
            <a href="<?php echo e(route('admin.payment-gateways.create')); ?>" class="btn btn-success btn-sm shadow-sm">
                <i class="fas fa-plus-circle"></i> Add New Gateway
            </a>
        </div>
    </div>

    <!-- Payment Gateway Settings Card -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fas fa-tools me-2"></i> Manage Payment Gateways</h4>
        </div>
        <div class="card-body p-4">
            <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <!-- Gateway Card -->
                <div class="gateway-card bg-white p-4 rounded mb-4 shadow-sm border position-relative">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <!-- Gateway Information -->
                        <div>
                            <h5 class="fw-bold text-dark"><?php echo e($gateway->gateway_name); ?></h5>
                            <div class="d-flex align-items-center mt-2">
                                <span class="badge rounded-pill bg-<?php echo e($gateway->is_active ? 'success' : 'danger'); ?> me-2">
                                    <?php echo e($gateway->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                                <span class="badge rounded-pill bg-info text-white me-2">
                                    <?php echo e($gateway->is_manual ? 'Manual' : 'Automated'); ?>

                                </span>
                                <small class="text-muted">
                                    <?php echo e($gateway->description ?? 'No description available'); ?>

                                </small>
                            </div>
                        </div>

                        <!-- Enable/Disable Switch with Enhanced Design -->
                        <div class="form-check form-switch d-flex align-items-center position-relative">
                            <input type="checkbox" class="form-check-input enhanced-switch" name="is_active" <?php echo e($gateway->is_active ? 'checked' : ''); ?> id="activeToggle<?php echo e($gateway->id); ?>" onchange="toggleGatewayStatus(<?php echo e($gateway->id); ?>, this)">
                            <label class="form-check-label fw-semibold ms-2" for="activeToggle<?php echo e($gateway->id); ?>">
                                <span class="status-label <?php echo e($gateway->is_active ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e($gateway->is_active ? 'Enabled' : 'Disabled'); ?>

                                </span>
                            </label>
                        </div>
                    </div>

                    <!-- Gateway Settings with Enhanced Input Design -->
                    <button class="btn btn-link text-decoration-none advanced-toggle-link" data-bs-toggle="collapse" data-bs-target="#gatewayDetails<?php echo e($gateway->id); ?>" aria-expanded="false" aria-controls="gatewayDetails<?php echo e($gateway->id); ?>">
                        <i class="fas fa-chevron-down"></i> Show/Hide Gateway Settings
                    </button>
                    <div id="gatewayDetails<?php echo e($gateway->id); ?>" class="collapse mt-3">
                        <form action="<?php echo e(route('admin.payment-gateways.update', $gateway->id)); ?>" method="POST" class="px-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="row g-4">
                                <!-- Transaction Fee -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold"><i class="fas fa-percent me-1 text-muted"></i> Transaction Fee (%)</label>
                                    <input type="number" step="0.01" name="transaction_fee" value="<?php echo e($gateway->transaction_fee); ?>" class="form-control form-control-lg border-0 shadow-sm" placeholder="Transaction Fee" required>
                                </div>

                                <!-- Environment -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold"><i class="fas fa-server me-1 text-muted"></i> Environment</label>
                                    <select name="environment" class="form-select form-select-lg border-0 shadow-sm" required>
                                        <option value="sandbox" <?php echo e($gateway->environment === 'sandbox' ? 'selected' : ''); ?>>Sandbox</option>
                                        <option value="production" <?php echo e($gateway->environment === 'production' ? 'selected' : ''); ?>>Production</option>
                                    </select>
                                </div>

                                <!-- Currency Selection with Icon -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold"><i class="fas fa-coins me-1 text-muted"></i> Currency</label>
                                    <select name="currency" class="form-select form-select-lg border-0 shadow-sm" required>
                                        <option value="usd" <?php echo e($gateway->currency === 'usd' ? 'selected' : ''); ?>>USD ($)</option>
                                        <option value="eur" <?php echo e($gateway->currency === 'eur' ? 'selected' : ''); ?>>EUR (€)</option>
                                        <option value="gbp" <?php echo e($gateway->currency === 'gbp' ? 'selected' : ''); ?>>GBP (£)</option>
                                    </select>
                                </div>

                                <!-- Minimum Transaction Amount -->
                                <div class="col-md-3">
                                    <label class="form-label fw-semibold"><i class="fas fa-money-bill-wave me-1 text-muted"></i> Min Transaction Amount</label>
                                    <input type="number" name="min_transaction_amount" value="<?php echo e($gateway->gateway_parameters['min_transaction_amount'] ?? 10); ?>" class="form-control form-control-lg border-0 shadow-sm" min="1" required>
                                </div>
                            </div>

                            <!-- URLs for Success and Cancellation with Badges -->
                            <div class="row g-4 mt-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold"><i class="fas fa-link me-1 text-muted"></i> Success URL <span class="badge bg-success">Required</span></label>
                                    <input type="url" name="success_url" value="<?php echo e($gateway->success_url); ?>" class="form-control form-control-lg border-0 shadow-sm" placeholder="https://yourdomain.com/success" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold"><i class="fas fa-times-circle me-1 text-muted"></i> Cancel URL <span class="badge bg-warning">Optional</span></label>
                                    <input type="url" name="cancel_url" value="<?php echo e($gateway->cancel_url); ?>" class="form-control form-control-lg border-0 shadow-sm" placeholder="https://yourdomain.com/cancel">
                                </div>
                            </div>

                            <!-- Manual Payment Details Section -->
                            <div class="row g-4 mt-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold"><i class="fas fa-wallet me-1 text-muted"></i> Manual Payment Type (e.g., BTC, LTC)</label>
                                    <input type="text" name="manual_payment_type" value="<?php echo e($gateway->gateway_parameters['manual_payment_type'] ?? ''); ?>" class="form-control form-control-lg border-0 shadow-sm" placeholder="e.g., Bitcoin, Litecoin">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold"><i class="fas fa-file-invoice-dollar me-1 text-muted"></i> Manual Payment Details (Address/ID)</label>
                                    <input type="text" name="manual_payment_details" value="<?php echo e($gateway->gateway_parameters['manual_payment_details'] ?? ''); ?>" class="form-control form-control-lg border-0 shadow-sm" placeholder="e.g., Wallet Address, Payment ID">
                                </div>
                            </div>

                            <!-- Divider -->
                            <div class="border-top my-4"></div>

                            <!-- Submit and Delete Buttons -->
                            <div class="row">
                                <div class="col-md-12 text-end">
                                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow me-2">
                                        <i class="fas fa-save"></i> Save Changes
                                    </button>
                                    <button type="button" class="btn btn-danger btn-lg shadow" data-bs-toggle="modal" data-bs-target="#deleteGatewayModal<?php echo e($gateway->id); ?>">
                                        <i class="fas fa-trash-alt"></i> Delete Gateway
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Delete Gateway Modal -->
                <div class="modal fade" id="deleteGatewayModal<?php echo e($gateway->id); ?>" tabindex="-1" aria-labelledby="deleteGatewayLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteGatewayLabel">Delete Payment Gateway</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                Are you sure you want to delete the "<?php echo e($gateway->gateway_name); ?>" payment gateway? This action cannot be undone.
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <form action="<?php echo e(route('admin.payment-gateways.delete', $gateway->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger">Delete Gateway</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <!-- No Gateways Found State -->
                <div class="text-center py-5">
                    <h5 class="text-muted mb-4">No Payment Gateways Found</h5>
                    <a href="<?php echo e(route('admin.payment-gateways.create')); ?>" class="btn btn-success shadow-sm">
                        <i class="fas fa-plus-circle"></i> Add New Gateway
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    // Toggle visibility for password fields
    function toggleVisibility(button) {
        const input = button.previousElementSibling;
        if (input.type === 'password') {
            input.type = 'text';
            button.innerHTML = '<i class="fas fa-eye-slash"></i>';
        } else {
            input.type = 'password';
            button.innerHTML = '<i class="fas fa-eye"></i>';
        }
    }

    // Toggle gateway status using AJAX
    function toggleGatewayStatus(gatewayId, checkbox) {
        const status = checkbox.checked ? 1 : 0;
        const statusLabel = checkbox.nextElementSibling.querySelector('.status-label');
        statusLabel.classList.toggle('text-success', status === 1);
        statusLabel.classList.toggle('text-danger', status === 0);
        statusLabel.textContent = status === 1 ? 'Enabled' : 'Disabled';

        // TODO: Implement actual server request to change the gateway status
        console.log(`Toggling gateway ${gatewayId} status to ${status}`);
    }

    // Tooltips for better UX
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\payment_gateways.blade.php ENDPATH**/ ?>