

<?php $__env->startSection('title', 'MT5 Trades'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h2 class="mt-4">My Trades</h2>

    <!-- Display Success and Error Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <!-- Trades Table -->
    <div class="card">
        <div class="card-body">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Trade ID</th>
                        <th>Asset</th>
                        <th>Volume</th>
                        <th>Type</th>
                        <th>Profit/Loss</th>
                        <th>Status</th>
                        <th>Opened At</th>
                        <th>Closed At</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($trade['trade_id']); ?></td>
                            <td><?php echo e($trade['asset']); ?></td>
                            <td><?php echo e($trade['volume']); ?></td>
                            <td><?php echo e(ucfirst($trade['type'])); ?></td>
                            <td class="<?php echo e($trade['profit'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e($trade['profit']); ?>

                            </td>
                            <td><?php echo e(ucfirst($trade['status'])); ?></td>
                            <td><?php echo e($trade['opened_at'] ?? 'N/A'); ?></td>
                            <td><?php echo e($trade['closed_at'] ?? 'N/A'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center">No trades found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\mt5_trades.blade.php ENDPATH**/ ?>