

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4 text-primary"><i class="fas fa-money-check-alt me-2"></i> Transfer Funds</h1>

    <div class="card shadow-lg border-0">
        <div class="card-header bg-gradient-primary text-white">
            <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i> Fund Transfer Form</h5>
        </div>
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.transferFunds.submit')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                
                <!-- User Selection -->
                <div class="mb-4">
                    <label for="user_id" class="form-label text-muted">Select User</label>
                    <select name="user_id" id="user_id" class="form-select shadow-sm" required>
                        <option value="" disabled selected>Choose a user...</option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Amount Input -->
                <div class="mb-4">
                    <label for="amount" class="form-label text-muted">Amount</label>
                    <input type="number" name="amount" id="amount" class="form-control shadow-sm" placeholder="Enter amount" required>
                </div>

                <!-- Action Selection -->
                <div class="mb-4">
                    <label for="action" class="form-label text-muted">Action</label>
                    <select name="action" id="action" class="form-select shadow-sm" required>
                        <option value="" disabled selected>Select action...</option>
                        <option value="deposit">Deposit to MT5</option>
                        <option value="withdraw">Withdraw from MT5</option>
                    </select>
                </div>

                <!-- Submit Button -->
                <div class="d-grid mt-4">
                    <button type="submit" class="btn btn-gradient-primary text-white py-2">
                        <i class="fas fa-paper-plane me-2"></i> Submit Transfer
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .form-label {
        font-weight: 600;
        color: #6c757d;
    }

    .btn-gradient-primary {
        background: linear-gradient(135deg, #007bff, #0056b3);
        border: none;
        font-size: 1rem;
        font-weight: 500;
        border-radius: 30px;
    }

    .btn-gradient-primary:hover {
        background: linear-gradient(135deg, #0056b3, #003e85);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

    .form-control, .form-select {
        border: 1px solid #ced4da;
        border-radius: 10px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        padding: 0.75rem;
    }

    .card-header {
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .card {
        border-radius: 20px;
    }

    .form-control:focus, .form-select:focus {
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        border-color: #007bff;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\transferFunds.blade.php ENDPATH**/ ?>