

<?php $__env->startSection('title', 'Add Payment Gateway'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-plus-circle me-2"></i> Add New Payment Gateway
        </h1>
        <a href="<?php echo e(route('admin.payment.gateways')); ?>" class="btn btn-outline-primary btn-sm shadow-sm">
            <i class="fas fa-arrow-left"></i> Back to Settings
        </a>
    </div>

    <!-- Payment Gateway Form -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex align-items-center">
            <h4 class="mb-0"><i class="fas fa-tools me-2"></i> Add Payment Gateway</h4>
        </div>
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.payment-gateways.store')); ?>" method="POST" class="gateway-form bg-white p-5 rounded shadow-sm border border-light">
                <?php echo csrf_field(); ?>

                <!-- Gateway Name -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Gateway Name</label>
                    <input type="text" name="gateway_name" class="form-control form-control-lg" placeholder="Enter Gateway Name" required>
                </div>

                <!-- Status Switch -->
                <div class="form-check form-switch mb-4">
                    <input type="checkbox" class="form-check-input" name="is_active" id="activeToggle">
                    <label class="form-check-label" for="activeToggle">Enable Gateway</label>
                </div>

                <!-- Transaction Fee -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Transaction Fee (%)</label>
                    <input type="number" step="0.01" name="transaction_fee" class="form-control form-control-lg" placeholder="Transaction Fee">
                </div>

                <!-- Environment -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Environment</label>
                    <select name="environment" class="form-select form-select-lg">
                        <option value="sandbox">Sandbox</option>
                        <option value="production">Production</option>
                    </select>
                </div>

                <!-- Currency -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Currency</label>
                    <select name="currency" class="form-select form-select-lg">
                        <option value="usd">USD ($)</option>
                        <option value="eur">EUR (€)</option>
                        <option value="gbp">GBP (£)</option>
                    </select>
                </div>

                <!-- Minimum Transaction Amount -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Min Transaction Amount</label>
                    <input type="number" name="min_transaction_amount" class="form-control form-control-lg" placeholder="Minimum Transaction Amount">
                </div>

                <!-- URLs -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Success URL</label>
                    <input type="url" name="success_url" class="form-control form-control-lg" placeholder="https://yourdomain.com/success">
                </div>
                <div class="mb-4">
                    <label class="form-label fw-semibold">Cancel URL</label>
                    <input type="url" name="cancel_url" class="form-control form-control-lg" placeholder="https://yourdomain.com/cancel">
                </div>

                <!-- Security Settings -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">API Key</label>
                    <input type="password" name="api_key" class="form-control form-control-lg" placeholder="Enter API Key">
                </div>
                <div class="mb-4">
                    <label class="form-label fw-semibold">API Secret</label>
                    <input type="password" name="api_secret" class="form-control form-control-lg" placeholder="Enter API Secret">
                </div>

                <!-- Webhook URL -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Webhook URL</label>
                    <input type="url" name="webhook_url" class="form-control form-control-lg" placeholder="https://yourdomain.com/webhook">
                </div>

                <!-- Notification Email -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Notification Email</label>
                    <input type="email" name="notification_email" class="form-control form-control-lg" placeholder="your-email@domain.com">
                </div>

                

                <!-- Submit Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow">
                        <i class="fas fa-save"></i> Add Gateway
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Toggle visibility for password fields
    function toggleVisibility(button) {
        const input = button.previousElementSibling;
        if (input.type === 'password') {
            input.type = 'text';
            button.innerHTML = '<i class="fas fa-eye-slash"></i>';
        } else {
            input.type = 'password';
            button.innerHTML = '<i class="fas fa-eye"></i>';
        }
    }

    // Tooltips for better UX
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\create_payment_gateway.blade.php ENDPATH**/ ?>