 <!-- Use the admin layout -->

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="text-primary fw-bold">Manage Transactions</h1>
        <div>
          <!--  <a href="<?php echo e(route('admin.transactions.export')); ?>" class="btn btn-outline-success btn-lg shadow-sm">
                <i class="fas fa-file-excel"></i> Export to Excel
            </a>  -->
        </div>
    </div>  

    <!-- Transactions Summary Section -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #3498db; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Pending Transactions</h5>
                    <h3 class="fw-bold"><?php echo e($pendingTransactionsCount ?? 0); ?></h3>
                    <i class="fas fa-hourglass-half fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #28a745; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Approved Transactions</h5>
                    <h3 class="fw-bold"><?php echo e($approvedTransactionsCount ?? 0); ?></h3>
                    <i class="fas fa-check-circle fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #e74c3c; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Rejected Transactions</h5>
                    <h3 class="fw-bold"><?php echo e($rejectedTransactionsCount ?? 0); ?></h3>
                    <i class="fas fa-times-circle fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filters Section -->
    <div class="card shadow mb-4 border-light">
        <div class="card-body">
            <form action="<?php echo e(route('admin.transactions.index')); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-lg-4">
                        <input type="text" name="search" class="form-control" placeholder="Search by user name or type" value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-lg-3">
                        <select name="filter" class="form-select">
                            <option value="">All Transactions</option>
                            <option value="deposit" <?php echo e(request('filter') == 'deposit' ? 'selected' : ''); ?>>Deposits</option>
                            <option value="withdrawal" <?php echo e(request('filter') == 'withdrawal' ? 'selected' : ''); ?>>Withdrawals</option>
                        </select>
                    </div>
                    <div class="col-lg-3">
                        <div class="input-group">
                            <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>" placeholder="Start Date">
                            <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>" placeholder="End Date">
                        </div>
                    </div>
                    <div class="col-lg-2 text-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-filter"></i> Apply Filters
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table Section -->
    <div class="card shadow-sm border-light">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($transaction->id); ?></td>
                                <td><?php echo e($transaction->user->name); ?></td>
                                <td>
                                    <span class="badge rounded-pill bg-<?php echo e($transaction->type === 'deposit' ? 'success' : 'warning'); ?>">
                                        <?php echo e(ucfirst($transaction->type)); ?>

                                    </span>
                                </td>
                                <td>$<?php echo e(number_format($transaction->amount, 2)); ?></td>
                                <td>
                                    <span class="badge rounded-pill bg-<?php echo e($transaction->status === 'approved' ? 'success' : ($transaction->status === 'rejected' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($transaction->status)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($transaction->created_at->format('d M Y, h:i A')); ?></td>
                                <td class="text-center">
                                    <?php if($transaction->status == 'pending'): ?>
                                        <form action="<?php echo e(route('admin.transactions.approve', $transaction->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-outline-success btn-sm" data-bs-toggle="tooltip" title="Approve Transaction">
                                                <i class="fas fa-check-circle"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.transactions.reject', $transaction->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-outline-danger btn-sm" data-bs-toggle="tooltip" title="Reject Transaction">
                                                <i class="fas fa-times-circle"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Processed</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">No transactions found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-end mt-4">
                <?php echo e($transactions->links()); ?>

            </div>
        </div>
    </div>

</div>

<!-- JavaScript -->
<script>
    // Tooltip Initialization
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\transactions\index.blade.php ENDPATH**/ ?>