

<?php $__env->startSection('title', 'Edit Role'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4 text-primary"><i class="fas fa-edit me-2"></i>Edit Role</h1>

    <form action="<?php echo e(route('admin.roles.update', $role->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="card shadow-lg border-0">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-user-shield me-2"></i> Role Details</h4>
            </div>
            <div class="card-body">
                <div class="form-group mb-4">
                    <label for="name" class="form-label"><i class="fas fa-user-tag me-2"></i>Role Name</label>
                    <input type="text" name="name" id="name" class="form-control form-control-lg" value="<?php echo e(old('name', $role->name)); ?>" required>
                </div>

                <div class="form-group mb-4">
                    <label for="permissions" class="form-label"><i class="fas fa-key me-2"></i>Permissions</label>
                    <select name="permissions[]" id="permissions" class="form-select form-select-lg" multiple>
                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($permission->id); ?>" <?php echo e($role->permissions->contains($permission) ? 'selected' : ''); ?>>
                                <?php echo e(ucfirst($permission->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="card-footer text-end">
                <button type="submit" class="btn btn-success btn-lg shadow-sm">
                    <i class="fas fa-save me-2"></i> Save Changes
                </button>
                <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary btn-lg shadow-sm">
                    <i class="fas fa-arrow-left me-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\roles\edit.blade.php ENDPATH**/ ?>