

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-primary fw-bold">Manage Deposits</h2>
        <button class="btn btn-outline-primary" onclick="window.location.reload();">
            <i class="fas fa-sync-alt"></i> Refresh
        </button>
    </div>

    <!-- Notifications -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if($deposits->isEmpty()): ?>
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>No pending deposit requests.
        </div>
    <?php else: ?>
        <!-- Deposits Summary -->
        <div class="row mb-4">
            <div class="col-md-4 mb-3">
                <div class="card border-light shadow-sm h-100">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <h5 class="card-title text-muted">Total Pending Deposits</h5>
                        <h3 class="text-warning fw-bold"><?php echo e($deposits->count()); ?></h3>
                        <i class="fas fa-clock fa-3x align-self-end text-warning-50"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card border-light shadow-sm h-100">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <h5 class="card-title text-muted">Total Approved Deposits</h5>
                        <h3 class="text-success fw-bold"><?php echo e($approvedDepositsCount); ?></h3>
                        <i class="fas fa-check-circle fa-3x align-self-end text-success-50"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card border-light shadow-sm h-100">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <h5 class="card-title text-muted">Total Rejected Deposits</h5>
                        <h3 class="text-danger fw-bold"><?php echo e($rejectedDepositsCount); ?></h3>
                        <i class="fas fa-times-circle fa-3x align-self-end text-danger-50"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Table -->
        <div class="card shadow border-light">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-table text-primary"></i> Pending Deposits</h5>
                <input type="text" id="searchDeposits" class="form-control w-25" placeholder="Search by user or status...">
            </div>
            <div class="card-body">
                <table class="table table-hover table-bordered" id="depositsTable">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date Requested</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($deposit->id); ?></td>
                                <td><?php echo e($deposit->user->name); ?></td>
                                <td>$<?php echo e(number_format($deposit->amount, 2)); ?></td>
                                <td>
                                    <span class="badge bg-warning"><?php echo e(ucfirst($deposit->status)); ?></span>
                                </td>
                                <td><?php echo e($deposit->created_at->format('d M Y, h:i A')); ?></td>
                                <td>
                                    <?php if($deposit->status == 'pending'): ?>
                                        <form action="<?php echo e(route('admin.deposits.approve', $deposit->id)); ?>" method="POST" style="display:inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-success btn-sm" data-bs-toggle="tooltip" title="Approve Deposit">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.deposits.reject', $deposit->id)); ?>" method="POST" style="display:inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" data-bs-toggle="tooltip" title="Reject Deposit">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <span class="text-muted">Processed</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <!-- Pagination -->
                <div class="d-flex justify-content-end mt-4">
                    <?php echo e($deposits->links()); ?>

                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
    // Tooltip Initialization
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Search Functionality
    document.getElementById('searchDeposits').addEventListener('keyup', function() {
        let filter = this.value.toLowerCase();
        let rows = document.querySelectorAll('#depositsTable tbody tr');
        rows.forEach(row => {
            let text = row.textContent.toLowerCase();
            row.style.display = text.includes(filter) ? '' : 'none';
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\deposits\index.blade.php ENDPATH**/ ?>