

<?php $__env->startSection('title', 'Manual Payment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-money-bill-wave me-2"></i> Manual Payment Details
        </h1>
        <a href="<?php echo e(route('wallet.index')); ?>" class="btn btn-outline-primary btn-sm shadow-sm">
            <i class="fas fa-arrow-left"></i> Back to Wallet
        </a>
    </div>

    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white">
            <h4 class="mb-0"><i class="fas fa-info-circle me-2"></i> Payment Instructions</h4>
        </div>
        <div class="card-body p-4">
            <h5 class="fw-bold">Gateway Name: <?php echo e($gateway->gateway_name); ?></h5>
            <p class="mb-4"><?php echo e($gateway->description ?? 'Please follow the instructions below to complete your payment.'); ?></p>

            <div class="row mb-3">
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Payment Address/Email</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-wallet"></i></span>
                        <input type="text" class="form-control" value="<?php echo e($gateway->gateway_parameters['payment_address'] ?? 'N/A'); ?>" readonly>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label fw-semibold">Transaction Amount (<?php echo e(strtoupper($gateway->currency)); ?>)</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-coins"></i></span>
                        <input type="text" class="form-control" value="<?php echo e(number_format($transaction->amount, 2)); ?>" readonly>
                    </div>
                </div>
            </div>

            <div class="alert alert-warning mt-4" role="alert">
                <h5 class="alert-heading"><i class="fas fa-exclamation-triangle"></i> Important Notice:</h5>
                <p>Please make sure to copy the address correctly and send the exact amount specified above. Transactions may take some time to be verified.</p>
            </div>

            <div class="text-end mt-5">
                <a href="<?php echo e(route('wallet.index')); ?>" class="btn btn-primary btn-lg">
                    <i class="fas fa-check-circle"></i> I have completed the payment
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\manual_payment_details.blade.php ENDPATH**/ ?>