@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">

        <!-- Main Content -->
        <main id="content" class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="container py-4">

                <!-- Header Section -->
                <div class="d-flex justify-content-between align-items-center">
                    <h2 class="text-center text-primary fw-bold">Welcome Back, {{ Auth::user()->name }}!</h2>
                    <div>
                        <button class="btn btn-primary shadow-sm me-2" onclick="window.location.href='{{ route('wallet.index') }}'">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                        <button class="btn btn-info shadow-sm" data-bs-toggle="modal" data-bs-target="#helpModal">
                            <i class="fas fa-question-circle"></i> Help
                        </button>
                    </div>
                </div>

                <!-- Wallet Summary Section with Savings Goal -->
                <div class="row mb-4 mt-3">
                    <div class="col-md-4 mb-3">
                        <div class="card text-white bg-gradient-primary h-100 shadow-lg border-light rounded-3 position-relative">
                            <div class="card-body d-flex flex-column justify-content-between">
                                <h5 class="card-title">Current Balance</h5>
                                <h2 class="card-text">${{ number_format($wallet->balance, 2) }}</h2>
                                <i class="fas fa-wallet fa-3x align-self-end text-white-50"></i>
                                <span class="position-absolute top-0 end-0 p-2" data-bs-toggle="tooltip" title="This is your current wallet balance">
                                    <i class="fas fa-info-circle text-light"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card text-white bg-gradient-success h-100 shadow-lg border-light rounded-3 position-relative">
                            <div class="card-body d-flex flex-column justify-content-between">
                                <h5 class="card-title">Total Deposited</h5>
                                <h2 class="card-text">${{ number_format($transactions->where('type', 'deposit')->where('status', 'completed')->sum('amount'), 2) }}</h2>
                                <i class="fas fa-arrow-circle-down fa-3x align-self-end text-white-50"></i>
                                <span class="position-absolute top-0 end-0 p-2" data-bs-toggle="tooltip" title="Total amount you have deposited into your wallet">
                                    <i class="fas fa-info-circle text-light"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="card text-dark bg-gradient-warning h-100 shadow-lg border-light rounded-3 position-relative">
                            <div class="card-body d-flex flex-column justify-content-between">
                                <h5 class="card-title">Total Withdrawn</h5>
                                <h2 class="card-text">${{ number_format($transactions->where('type', 'withdrawal')->where('status', 'completed')->sum('amount'), 2) }}</h2>
                                <i class="fas fa-arrow-circle-up fa-3x align-self-end text-dark-50"></i>
                                <span class="position-absolute top-0 end-0 p-2" data-bs-toggle="tooltip" title="Total amount withdrawn from your wallet">
                                    <i class="fas fa-info-circle text-dark"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions Section -->
                <div class="row mb-4 text-center">
                    <div class="col-md-4">
                        <button class="btn btn-outline-success w-100 shadow-sm py-3" data-bs-toggle="modal" data-bs-target="#depositModal">
                            <i class="fas fa-plus-circle"></i> Deposit Funds
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button class="btn btn-outline-danger w-100 shadow-sm py-3" data-bs-toggle="modal" data-bs-target="#withdrawModal">
                            <i class="fas fa-minus-circle"></i> Withdraw Funds
                        </button>
                    </div>
                    <div class="col-md-4">
                        <button id="downloadCSV" class="btn btn-outline-primary w-100 shadow-sm py-3">
                            <i class="fas fa-file-download"></i> Download Transactions
                        </button>
                    </div>
                </div>

            <!-- Deposit Modal -->
<div class="modal fade" id="depositModal" tabindex="-1" aria-labelledby="depositModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="{{ route('wallet.deposit') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="depositModalLabel">Deposit Funds</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="amount">Amount</label>
                        <input type="number" name="amount" class="form-control" min="10" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="payment_gateway">Payment Gateway</label>
                        <select name="payment_gateway" class="form-control" required>
                            @foreach($activeGateways as $gateway)
                                <option value="{{ $gateway->gateway_name }}">{{ $gateway->gateway_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <p class="text-muted mt-2">
                        Note: If you select a manual payment gateway, you will be provided with payment instructions to complete the deposit.
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Proceed with Deposit</button>
                </div>
            </div>
        </form>
    </div>
</div>

           <!-- Withdraw Modal -->
<div class="modal fade" id="withdrawModal" tabindex="-1" aria-labelledby="withdrawModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="{{ route('wallet.initiateWithdraw') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="withdrawModalLabel">Withdraw Funds</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="amount">Amount</label>
                        <input type="number" name="amount" class="form-control" min="10" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="payment_method">Payment Method</label>
                        <select name="payment_method" class="form-control" required>
                            <option value="BankTransfer">Bank Transfer</option>
                            <option value="PayPal">PayPal</option>
                            <option value="CryptoWallet">Crypto Wallet</option>
                            <!-- Add more options if necessary -->
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger">Withdraw</button>
                </div>
            </div>
        </form>
    </div>
</div>

                <!-- Transaction History Section -->
                <div class="card shadow-lg mb-5 border-light">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="card-title"><i class="fas fa-history text-secondary"></i> Transaction History</h5>
                            <div class="d-flex align-items-center">
                                <input type="text" id="searchTransactions" class="form-control w-50 me-2" placeholder="Search by amount or status...">
                                <button class="btn btn-outline-secondary" onclick="clearSearch()">Clear</button>
                            </div>
                        </div>
                        <table class="table table-hover table-bordered">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody id="transactionTable">
                                @foreach($transactions as $transaction)
                                <tr>
                                    <td>{{ $transaction->id }}</td>
                                    <td>
                                        <span class="badge bg-{{ $transaction->type === 'deposit' ? 'primary' : 'warning' }}">
                                            {{ ucfirst($transaction->type) }}
                                        </span>
                                    </td>
                                    <td>${{ number_format($transaction->amount, 2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $transaction->status === 'completed' ? 'success' : ($transaction->status === 'rejected' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction->created_at->format('d M Y, h:i A') }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </main>
    </div>
</div>

<script>
    // Tooltip Initialization
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Search Filter for Transactions
    document.getElementById('searchTransactions').addEventListener('keyup', function() {
        let filter = this.value.toLowerCase();
        let rows = document.querySelectorAll('#transactionTable tr');
        rows.forEach(row => {
            let text = row.textContent.toLowerCase();
            row.style.display = text.includes(filter) ? '' : 'none';
        });
    });

    // Clear Search Filter
    function clearSearch() {
        document.getElementById('searchTransactions').value = '';
        document.querySelectorAll('#transactionTable tr').forEach(row => {
            row.style.display = '';
        });
    }

    // Download Transaction History as CSV
    document.getElementById('downloadCSV').addEventListener('click', function() {
        let csvContent = "data:text/csv;charset=utf-8,Transaction ID,Type,Amount,Status,Date\n";
        document.querySelectorAll('#transactionTable tr').forEach(function(row) {
            let rowData = [];
            row.querySelectorAll('td').forEach(function(cell) {
                rowData.push(cell.textContent);
            });
            csvContent += rowData.join(",") + "\n";
        });

        let link = document.createElement("a");
        link.setAttribute("href", encodeURI(csvContent));
        link.setAttribute("download", "transaction_history.csv");
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });
</script>

@endsection
