@extends('layouts.user')

@section('title', 'Create Demo MT5 Account')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4">Create Demo MT5 Account</h2>

    <!-- Display Success and Error Messages -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Demo Account Creation Form -->
    <form action="{{ route('user.mt5.create-demo-account') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="leverage" class="form-label">Leverage</label>
            <input type="number" name="leverage" id="leverage" class="form-control @error('leverage') is-invalid @enderror" value="{{ old('leverage') }}" required>
            @error('leverage')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="currency" class="form-label">Currency</label>
            <input type="text" name="currency" id="currency" class="form-control @error('currency') is-invalid @enderror" value="{{ old('currency') }}" required>
            @error('currency')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="initial_balance" class="form-label">Initial Balance</label>
            <input type="number" name="initial_balance" id="initial_balance" class="form-control @error('initial_balance') is-invalid @enderror" value="{{ old('initial_balance') }}" required>
            @error('initial_balance')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label for="group" class="form-label">Group</label>
            <input type="text" name="group" id="group" class="form-control @error('group') is-invalid @enderror" value="{{ old('group') }}" required>
            @error('group')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="btn btn-primary">Create Demo Account</button>
    </form>
</div>
@endsection
