@extends('layouts.app')

@section('title', 'User Activity Logs')

@section('content')
<div class="container-fluid py-5" style="background: linear-gradient(135deg, #f8f9fa, #ffffff);">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-gradient">
            <i class="fas fa-clipboard-list me-2"></i> Activity Logs
        </h2>
        <a href="{{ route('user.dashboard') }}" class="btn btn-outline-primary btn-sm shadow-sm rounded-pill">
            <i class="fas fa-arrow-left me-2"></i> Back to Dashboard
        </a>
    </div>

    <!-- Logs Section -->
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="m-0">
                <i class="fas fa-history me-2"></i> User Activity Logs
            </h5>
            <form class="d-flex gap-2" method="GET" action="{{ route('user.activity.logs') }}">
                <input type="text" name="search" class="form-control form-control-sm rounded-pill shadow-sm" placeholder="Search logs..." value="{{ request('search') }}">
                <button type="submit" class="btn btn-light btn-sm rounded-pill shadow-sm">
                    <i class="fas fa-search"></i>
                </button>
            </form>
        </div>
        <div class="card-body" style="background: linear-gradient(135deg, #ffffff, #f0f4f9);">
            @if($logs->isNotEmpty())
                <div class="table-responsive">
                    <table class="table table-hover table-bordered align-middle">
                        <thead class="table-gradient">
                            <tr>
                                <th>#</th>
                                <th>Action</th>
                                <th>IP Address</th>
                                <th>Timestamp</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($logs as $log)
                                <tr class="table-row-hover">
                                    <td class="text-center fw-bold">{{ $loop->iteration }}</td>
                                    <td>
                                        <span class="badge bg-gradient-primary text-dark rounded-pill shadow-sm">
                                            {{ ucfirst($log->action) }}
                                        </span>
                                    </td>
                                    <td class="text-primary fw-semibold">{{ $log->ip_address }}</td>
                                    <td>
                                        <span class="text-dark fw-semibold">{{ $log->created_at->format('d M Y, H:i:s') }}</span>
                                    </td>
                                    <td>
                                        <span class="badge {{ $log->status == 'success' ? 'bg-gradient-success' : 'bg-gradient-danger' }} text-white rounded-pill shadow-sm">
                                            {{ ucfirst($log->status) }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3 d-flex justify-content-center">
                    {{ $logs->links('pagination::bootstrap-5') }}
                </div>
            @else
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No activity logs found.
                </div>
            @endif
        </div>
    </div>
</div>

<style>
/* General Styling */
.container-fluid {
    max-width: 1400px;
}

/* Gradient Text */
.text-gradient {
    background: -webkit-linear-gradient(45deg, #007bff, #0056b3);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* Card Styling */
.card {
    border-radius: 20px;
}
.card-header {
    font-size: 1.2rem;
    font-weight: bold;
    text-transform: uppercase;
}

/* Table Styling */
.table-hover tbody tr:hover {
    background: rgba(0, 123, 255, 0.1);
}
.table th, .table td {
    vertical-align: middle;
    font-size: 1rem;
    text-align: center;
    color: #343a40;
}
.table th {
    text-transform: uppercase;
    font-weight: bold;
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: #ffffff;
    border: 1px solid #dee2e6;
}
.table-row-hover:hover {
    background: linear-gradient(135deg, #e3f2fd, #ffffff);
}

/* Badge Styling */
.badge {
    font-size: 0.9rem;
    padding: 0.5rem 1rem;
    font-weight: 600;
}

/* Buttons */
.btn-outline-primary {
    border-color: #007bff;
    color: #007bff;
    transition: all 0.3s ease-in-out;
}
.btn-outline-primary:hover {
    background: #007bff;
    color: #fff;
}

/* Search Input Styling */
.form-control {
    border-radius: 12px;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
}
.form-control:focus {
    box-shadow: 0px 8px 20px rgba(0, 123, 255, 0.25);
    border-color: #007bff;
}

/* Responsive Design */
@media (max-width: 768px) {
    .btn-outline-primary {
        font-size: 0.9rem;
        padding: 8px 15px;
    }
    .card-header h5 {
        font-size: 1rem;
    }
}
</style>
@endsection
