<!-- Fixed Sidebar -->
<nav id="sidebar" class="bg-dark text-white" style="overflow-y: auto; max-height: 100vh;">
    <div class="sidebar-header text-center py-4">
        <h4>{{ config('app.name', 'Laravel') }}</h4>
    </div>
    <ul class="list-unstyled components">
        <!-- Dashboard Link -->
        <li class="nav-item">
            <a href="{{ route('user.dashboard') }}" class="nav-link text-white {{ request()->is('user/dashboard') ? 'active' : '' }}">
                <i class="fas fa-home me-2"></i> Dashboard
            </a>
        </li>

        <!-- Wallet Link -->
        <li class="nav-item">
            <a href="{{ route('user.wallet.index') }}" class="nav-link text-white {{ request()->is('user/wallet*') ? 'active' : '' }}">
                <i class="fas fa-wallet me-2"></i> Wallet
            </a>
        </li>

        <!-- Deposit Funds -->
        <li class="nav-item">
            <a href="{{ route('user.deposit') }}" class="nav-link text-white {{ request()->routeIs('user.deposit') ? 'active' : '' }}">
                <i class="fas fa-coins me-2"></i> Deposit Funds
            </a>
        </li>

        <!-- Trades Link -->
        <li class="nav-item">
            <a href="{{ route('user.trades') }}" class="nav-link text-white {{ request()->is('user/trades*') ? 'active' : '' }}">
                <i class="fas fa-chart-line me-2"></i> Trades
            </a>
        </li>

        <!-- Referrals Link -->
        <li class="nav-item">
            <a href="{{ route('referrals.index') }}" class="nav-link text-white {{ request()->is('referrals*') ? 'active' : '' }}">
                <i class="fas fa-users me-2"></i> Referrals
            </a>
        </li>

        <!-- Activity Logs Link -->
       <li class="nav-item">
    <a href="{{ route('user.activity.logs') }}" class="nav-link text-white  {{ request()->routeIs('user.activity.logs') ? 'active' : '' }}">
        <i class="fas fa-clipboard-list me-2"></i>
        <span>Activity Logs</span>
    </a>
</li>


        <!-- Transfer Funds Link -->
        <li class="nav-item">
            <a href="{{ route('user.transferFunds') }}" class="nav-link text-white {{ request()->is('user/transfer-funds') ? 'active' : '' }}">
                <i class="fas fa-exchange-alt me-2"></i> Transfer Funds
            </a>
        </li>

        <!-- Open Live Account -->
        <li class="nav-item">
            <a href="{{ route('user.mt5.createLive') }}" class="nav-link text-white {{ request()->is('user/mt5/create-live') ? 'active' : '' }}">
                <i class="fas fa-user-plus me-2"></i> Open Live Account
            </a>
        </li>

        <!-- Open Demo Account -->
        <li class="nav-item">
            <a href="{{ route('user.mt5.createDemo') }}" class="nav-link text-white {{ request()->is('user/mt5/create-demo') ? 'active' : '' }}">
                <i class="fas fa-desktop me-2"></i> Open Demo Account
            </a>
        </li>

        <!-- My Trades -->
        <li class="nav-item">
            <a href="{{ route('user.mt5.trades') }}" class="nav-link text-white {{ request()->is('user/mt5/trades') ? 'active' : '' }}">
                <i class="fas fa-chart-line me-2"></i> My Trades
            </a>
        </li>




        <!-- IB Dashboard -->
        <li class="nav-item">
            <a href="{{ route('user.ib.dashboard') }}" class="nav-link text-white {{ request()->is('user/ib-dashboard') ? 'active' : '' }}">
                <i class="fas fa-sitemap me-2"></i> IB Dashboard
            </a>
        </li>

        <!-- IB Tree -->
        <li class="nav-item">
            <a href="{{ route('user.ib.tree') }}" class="nav-link text-white {{ request()->is('user/ib-tree') ? 'active' : '' }}">
                <i class="fas fa-tree me-2"></i> IB Tree
            </a>
        </li>

        <li class="nav-item">
    <a href="{{ route('user.ib.reports') }}" class="nav-link text-white ">
        <i class="fas fa-chart-line me-2"></i> IB Reports
    </a>
</li>

        <!-- KYC -->
        <li class="nav-item">
            <a href="{{ route('user.kyc') }}" class="nav-link text-white {{ request()->is('kyc') ? 'active' : '' }}">
                <i class="fas fa-id-card me-2"></i> KYC Submission
            </a>
        </li>

        <!--- supportticket -->
<li class="nav-item">
    <a href="{{ route('user.support.index') }}" class="nav-link text-white {{ request()->routeIs('user.support.*') ? 'active' : '' }}">
        <i class="fas fa-ticket-alt"></i> Support Tickets
    </a>
</li>


        <!-- Profile Link -->
        <li class="nav-item">
            <a href="{{ route('profile.show') }}" class="nav-link text-white {{ request()->is('profile*') ? 'active' : '' }}">
                <i class="fas fa-user me-2"></i> Profile
            </a>
        </li>

        <!-- Logout -->
        <li class="nav-item">
            <a href="{{ route('logout') }}" 
               class="nav-link text-white" 
               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="fas fa-sign-out-alt me-2"></i> Logout
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </li>
    </ul>
</nav>
