@extends('layouts.admin')

@section('title', 'View Ticket')

@section('content')
<div class="container-fluid px-4">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <h2 class="fw-bold text-gradient">
            <i class="fas fa-ticket-alt me-2"></i> Ticket #{{ $ticket->id }} - {{ $ticket->subject }}
        </h2>
        <a href="{{ route('admin.support.index') }}" class="btn btn-outline-primary btn-sm shadow rounded-pill">
            <i class="fas fa-arrow-left me-2"></i> Back to Tickets
        </a>
    </div>

    <!-- Ticket Details Card -->
    <div class="card shadow border-0 mb-4 rounded-5">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="m-0">
                <i class="fas fa-info-circle me-2"></i> Ticket Details
            </h5>
            <form action="{{ route('admin.support.updateStatus', $ticket->id) }}" method="POST" class="d-flex align-items-center gap-2">
                @csrf
                @method('POST')
                <select name="status" class="form-select form-select-sm rounded-pill">
                    <option value="open" @if($ticket->status == 'open') selected @endif>Open</option>
                    <option value="in_progress" @if($ticket->status == 'in_progress') selected @endif>In Progress</option>
                    <option value="completed" @if($ticket->status == 'completed') selected @endif>Completed</option>
                    <option value="closed" @if($ticket->status == 'closed') selected @endif>Closed</option>
                </select>
                <button type="submit" class="btn btn-light btn-sm shadow-sm rounded-pill">
                    <i class="fas fa-sync-alt"></i> Update
                </button>
            </form>
        </div>
        <div class="card-body">
            <div class="row g-4">
                <div class="col-md-6">
                    <p class="fw-bold text-dark mb-2"><strong>User:</strong> {{ $ticket->user->name }}</p>
                    <p class="fw-bold text-dark mb-2"><strong>Email:</strong> 
                        <a href="mailto:{{ $ticket->user->email }}" class="text-primary text-decoration-none">
                            {{ $ticket->user->email }}
                        </a>
                    </p>
                </div>
                <div class="col-md-6">
                    <p class="fw-bold text-dark mb-2"><strong>Status:</strong> 
                        <span class="badge 
                            @if($ticket->status == 'open') bg-primary 
                            @elseif($ticket->status == 'in_progress') bg-warning text-dark 
                            @elseif($ticket->status == 'completed') bg-success 
                            @elseif($ticket->status == 'closed') bg-danger 
                            @endif">
                            {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                        </span>
                    </p>
                    <p class="fw-bold text-dark mb-2"><strong>Created At:</strong> {{ $ticket->created_at->format('Y-m-d H:i:s') }}</p>
                </div>
            </div>
            <hr class="my-4">
            <h5 class="fw-bold text-gradient">Description</h5>
            <p class="p-4 bg-light text-dark rounded shadow">{{ $ticket->description }}</p>
            @if ($ticket->attachment)
                <p><strong>Attachment:</strong></p>
                <a href="{{ asset('storage/' . $ticket->attachment) }}" target="_blank" class="btn btn-outline-info btn-sm rounded-pill">
                    <i class="fas fa-download me-1"></i> View/Download
                </a>
            @endif
        </div>
    </div>

    <!-- Replies Section -->
    <div class="card shadow border-0 mb-4 rounded-5">
        <div class="card-header bg-gradient-secondary text-white d-flex align-items-center rounded-top">
            <h5 class="m-0">
                <i class="fas fa-comments me-2"></i> Replies
            </h5>
        </div>
        <div class="card-body">
            @forelse ($ticket->replies as $reply)
                <div class="reply-box p-4 rounded mb-4 shadow-sm" style="background: #f9f9f9;">
                    <div class="d-flex justify-content-between">
                        <p class="mb-0 fw-bold text-dark">
                            {{ $reply->user_id ? $reply->user->name : 'Admin' }}
                            <span class="text-muted small">({{ $reply->created_at->format('Y-m-d H:i:s') }})</span>
                        </p>
                        <span class="badge {{ $reply->user_id ? 'bg-secondary' : 'bg-info' }}">
                            {{ $reply->user_id ? 'User' : 'Admin' }}
                        </span>
                    </div>
                    <p class="mt-2 text-dark">{{ $reply->message }}</p>
                    @if ($reply->attachment)
                        <a href="{{ asset('storage/' . $reply->attachment) }}" target="_blank" class="btn btn-outline-info btn-sm mt-2 rounded-pill">
                            <i class="fas fa-download me-1"></i> View/Download Attachment
                        </a>
                    @endif
                </div>
            @empty
                <p class="text-muted text-center">No replies yet.</p>
            @endforelse

            <!-- Reply Form -->
            <form action="{{ route('admin.support.reply', $ticket->id) }}" method="POST" class="mt-4" enctype="multipart/form-data">
                @csrf
                <div class="form-group mb-3">
                    <label for="message" class="form-label fw-bold">Your Reply</label>
                    <textarea name="message" id="message" rows="4" class="form-control rounded-3 shadow-sm" placeholder="Type your reply here..." required></textarea>
                </div>
                <div class="form-group mb-3">
                    <label for="attachment" class="form-label fw-bold">Attachment (Optional)</label>
                    <input type="file" name="attachment" id="attachment" class="form-control shadow-sm">
                    <small class="text-muted">Allowed file types: jpg, jpeg, png, pdf, doc, docx (max: 2MB)</small>
                </div>
                <button type="submit" class="btn btn-success shadow-sm rounded-pill">
                    <i class="fas fa-paper-plane"></i> Send Reply
                </button>
            </form>
        </div>
    </div>
</div>

<style>
/* Advanced Styling */
.text-gradient {
    background: -webkit-linear-gradient(45deg, #007bff, #0056b3);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.card-header {
    background: linear-gradient(45deg, #6c757d, #5a6268);
}

.reply-box {
    border-left: 5px solid #007bff;
    padding: 20px;
}

.reply-box .badge {
    font-size: 0.9rem;
    padding: 0.4rem 0.8rem;
}

.btn-success {
    background: linear-gradient(135deg, #28a745, #218838);
    border: none;
}

.btn-success:hover {
    background: linear-gradient(135deg, #218838, #1e7e34);
}

.badge {
    font-size: 0.85rem;
    padding: 0.4rem 0.8rem;
    border-radius: 1rem;
    font-weight: bold;
}

.text-muted {
    font-size: 0.9rem;
}

.shadow {
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
}

.bg-gradient-secondary {
    background: linear-gradient(45deg, #6c757d, #5a6268);
    border: none;
}
</style>
@endsection
