@extends('layouts.admin')

@section('title', 'Edit Role')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4 text-primary"><i class="fas fa-edit me-2"></i>Edit Role</h1>

    <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="card shadow-lg border-0">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="fas fa-user-shield me-2"></i> Role Details</h4>
            </div>
            <div class="card-body">
                <div class="form-group mb-4">
                    <label for="name" class="form-label"><i class="fas fa-user-tag me-2"></i>Role Name</label>
                    <input type="text" name="name" id="name" class="form-control form-control-lg" value="{{ old('name', $role->name) }}" required>
                </div>

                <div class="form-group mb-4">
                    <label for="permissions" class="form-label"><i class="fas fa-key me-2"></i>Permissions</label>
                    <select name="permissions[]" id="permissions" class="form-select form-select-lg" multiple>
                        @foreach($permissions as $permission)
                            <option value="{{ $permission->id }}" {{ $role->permissions->contains($permission) ? 'selected' : '' }}>
                                {{ ucfirst($permission->name) }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="card-footer text-end">
                <button type="submit" class="btn btn-success btn-lg shadow-sm">
                    <i class="fas fa-save me-2"></i> Save Changes
                </button>
                <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary btn-lg shadow-sm">
                    <i class="fas fa-arrow-left me-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>
@endsection
