@extends('layouts.admin')

@section('content')
<div class="container">
    <h1 class="mb-4">MT5 API Settings</h1>

    <!-- Success Message -->
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- API Settings Form -->
    <form action="{{ route('admin.mt5.api.setting.update') }}" method="POST">
        @csrf

        <!-- Server Type -->
        <div class="mb-3">
            <label for="server_type" class="form-label">Server Type</label>
            <select name="server_type" id="server_type" class="form-select">
                <option value="real" {{ old('server_type', $settings->where('server_type', 'real')->first()?->server_type) === 'real' ? 'selected' : '' }}>Real</option>
                <option value="demo" {{ old('server_type', $settings->where('server_type', 'demo')->first()?->server_type) === 'demo' ? 'selected' : '' }}>Demo</option>
            </select>
        </div>

        <!-- API URL -->
        <div class="mb-3">
            <label for="api_url" class="form-label">API URL</label>
            <input type="url" name="api_url" id="api_url" class="form-control" value="{{ old('api_url', $settings->where('server_type', 'real')->first()?->api_url) }}" required>
        </div>

        <!-- API Key -->
        <div class="mb-3">
            <label for="api_key" class="form-label">API Key</label>
            <input type="text" name="api_key" id="api_key" class="form-control" value="{{ old('api_key', $settings->where('server_type', 'real')->first()?->api_key) }}" required>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">Update Settings</button>
    </form>
</div>
@endsection
