@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>MT5 Accounts</h2>
        <a href="{{ route('admin.mt5.createAccount') }}" class="btn btn-primary">Create New Account</a>
    </div>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <th>Login</th>
                    <th>Name</th>
                    <th>Group</th>
                    <th>Leverage</th>
                    <th>Balance</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($accounts as $account)
                    <tr>
                        <td>{{ $account['login'] }}</td>
                        <td>{{ $account['name'] }}</td>
                        <td>{{ $account['group'] }}</td>
                        <td>{{ $account['leverage'] }}</td>
                        <td>${{ number_format($account['balance'], 2) }}</td>
                        <td>
                            @if ($account['status'] === 'Active')
                                <span class="badge badge-success">Active</span>
                            @else
                                <span class="badge badge-secondary">{{ $account['status'] }}</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.mt5.viewAccount', $account['login']) }}" class="btn btn-info btn-sm">View</a>
                            <a href="{{ route('admin.mt5.editAccount', $account['login']) }}" class="btn btn-warning btn-sm">Edit</a>
                            <form action="{{ route('admin.mt5.deleteAccount', $account['login']) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this account?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">No accounts found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
