<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class KycStatusUpdated extends Notification
{
    use Queueable;

    protected $status;
    protected $remark;

    public function __construct($status, $remark = null)
    {
        $this->status = $status;
        $this->remark = $remark;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        $message = (new MailMessage)
            ->subject('KYC Status Updated')
            ->line("Your KYC status has been updated to: {$this->status}.");

        if ($this->remark) {
            $message->line("Remark: {$this->remark}");
        }

        return $message->line('Thank you for completing the KYC process!');
    }

    public function toArray($notifiable)
    {
        return [
            'status' => $this->status,
            'remark' => $this->remark,
        ];
    }
}
