<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = ['name'];

    /**
     * Define the relationship between permissions and roles.
     * 
     * A permission can belong to many roles.
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'role_permission', 'permission_id', 'role_id');
    }

    /**
     * Check if a permission is associated with a specific role.
     * 
     * @param string $roleName
     * @return bool
     */
    public function hasRole($roleName)
    {
        return $this->roles->contains('name', $roleName);
    }

    /**
     * Retrieve all unique permissions for a user through roles.
     *
     * @return \Illuminate\Support\Collection
     */
    public function permissionsForUser()
    {
        return $this->roles->flatMap(function ($role) {
            return $role->permissions;
        })->unique();
    }
}
