<?php

namespace App\MT5\Services;

use App\MT5\MT5Client;
use App\MT5\Entities\User;
use App\MT5\Entities\Trade;
use Exception;

class MT5Service
{
    private $client;

    public function __construct()
    {
        // Replace with dynamic values from your database or configuration
        $this->client = (new MT5Client('127.0.0.1', 443, 'manager', 'password'))->connect();
    }

    public function createAccount(array $data)
    {
        $user = new User($data);
        return $this->client->sendRequest([
            'action' => 'create_account',
            'data' => $user,
        ]);
    }

    public function getTrades($login)
    {
        return $this->client->sendRequest([
            'action' => 'get_trades',
            'data' => ['login' => $login],
        ]);
    }

    public function transferFunds(array $data)
    {
        $trade = new Trade($data);
        return $this->client->sendRequest([
            'action' => 'transfer_funds',
            'data' => $trade,
        ]);
    }

    public function disconnect()
    {
        $this->client->disconnect();
    }
}
