<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|array  $role
     * @return mixed
     */
    public function handle($request, Closure $next, $role)
    {
        // Retrieve the authenticated user
        $user = Auth::user();

        // Ensure the user is logged in
        if (!$user) {
            abort(403, 'Unauthorized: User is not logged in.');
        }

        // Check if the user has any assigned roles
        if (!$user->roles || $user->roles->isEmpty()) {
            abort(403, 'Unauthorized: User has no roles assigned.');
        }

        // Normalize the role parameter to an array
        $roles = is_array($role) ? $role : [$role];

        // Check if the user has at least one of the required roles
        if (!$user->hasAnyRole($roles)) {
            abort(403, 'Unauthorized: Insufficient permissions.');
        }

        return $next($request);
    }
}
