<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;

class AdminSettingsController extends Controller
{
    /**
     * Display the settings page.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // Retrieve all settings and pass them to the view
        $settings = Setting::all()->pluck('value', 'key')->toArray();
        return view('admin.settings', compact('settings'));
    }

    /**
     * Update settings.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request)
    {
        // Validate the incoming settings data
        $validated = $request->validate([
            'fund_transfer_limit' => 'nullable|numeric|min:0',      // Maximum fund transfer limit
            'fund_transfer_minimum' => 'nullable|numeric|min:0',   // Minimum fund transfer amount
            'transaction_fee' => 'nullable|numeric|min:0|max:100', // Transaction fee percentage
            'currency' => 'nullable|string|max:10',                // Default currency
            'user_registration' => 'nullable|boolean',             // Allow/Disallow user registration
            'trade_management' => 'nullable|boolean',              // Enable/Disable trade management
        ]);

        // Update each setting in the database
        foreach ($validated as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        return redirect()->back()->with('success', 'Settings updated successfully.');
    }
}
