<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\CommissionWithdrawal;
use App\Models\Referral;
use Illuminate\Http\Request;
use App\Models\IBRelationship;
use App\Models\IBHierarchy;
use App\Models\User;

class AdminIBReportController extends Controller
{
    public function index()
    {
        $withdrawals = CommissionWithdrawal::with('user')->paginate(10);

        return view('admin.ib-reports.index', compact('withdrawals'));
    }

    public function show($id)
    {
        $referrals = Referral::where('referrer_id', $id)->with('referredUser')->paginate(10);
        $totalEarnings = Referral::where('referrer_id', $id)->sum('earnings');

        return view('admin.ib-reports.show', compact('referrals', 'totalEarnings'));
    }

    public function approveWithdrawal($id)
    {
        $withdrawal = CommissionWithdrawal::findOrFail($id);
        $withdrawal->update(['status' => 'approved', 'approved_by' => auth()->id()]);

        return redirect()->route('admin.ib-reports')->with('success', 'Withdrawal approved.');
    }

    public function rejectWithdrawal(Request $request, $id)
    {
        $withdrawal = CommissionWithdrawal::findOrFail($id);
        $withdrawal->update(['status' => 'rejected', 'remarks' => $request->remarks]);

        return redirect()->route('admin.ib-reports')->with('success', 'Withdrawal rejected.');
    }
}
