

<?php $__env->startSection('title', 'Manage IB Commission Levels'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary text-center fw-bold">
        <i class="fas fa-percent me-2"></i> Manage IB Commission Levels
    </h2>

    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-list me-2"></i> Commission Levels</strong>
            <a href="<?php echo e(route('admin.ib-commission-levels.create')); ?>" class="btn btn-light btn-sm shadow-sm rounded-pill">
                <i class="fas fa-plus-circle me-2"></i> Add New Level
            </a>
        </div>
        <div class="card-body bg-light">
            <?php if($commissionLevels->isEmpty()): ?>
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No commission levels found.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle text-center">
                        <thead class="table-primary">
                            <tr>
                                <th>Level</th>
                                <th>Commission Percentage (%)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $commissionLevels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($level->level); ?></td>
                                    <td><?php echo e($level->commission_percentage); ?>%</td>
                                    <td>
                                        <a href="<?php echo e(route('admin.ib-commission-levels.edit', $level->id)); ?>" class="btn btn-warning btn-sm shadow-sm rounded-pill">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="<?php echo e(route('admin.ib-commission-levels.destroy', $level->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this level?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm shadow-sm rounded-pill">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\ib-commission-levels\index.blade.php ENDPATH**/ ?>