

<ul class="tree">
    <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="tree-node-wrapper">
            <div class="tree-node" data-toggle="tooltip" data-tooltip="Email: <?php echo e($node['user']->email); ?> | Level: <?php echo e($node['level']); ?>">
                <div class="node-content">
                    <div class="node-header d-flex align-items-center justify-content-center">
                        <div class="node-icon me-2">
                            <i class="bi bi-person-circle fs-3 text-primary"></i> <!-- Bootstrap icon -->
                        </div>
                        <div class="node-details">
                            <strong class="node-name"><?php echo e($node['user']->name); ?></strong>
                            <div class="node-email"><?php echo e($node['user']->email); ?></div>
                            <div class="node-level">Level: <?php echo e($node['level']); ?></div>
                            <?php if($node['user']->is_active): ?>
                                <span class="badge node-badge node-badge-active">Active</span>
                            <?php else: ?>
                                <span class="badge node-badge node-badge-inactive">Inactive</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="node-actions mt-2">
                        <a href="<?php echo e(route('admin.ib.tree', ['id' => $node['user']->id])); ?>" class="btn btn-gradient-primary btn-sm shadow-sm rounded-pill" title="Show Subtree">
                            <i class="fas fa-sitemap"></i>
                        </a>
                        <a href="<?php echo e(route('admin.ib.edit', ['id' => $node['user']->id])); ?>" class="btn btn-gradient-secondary btn-sm shadow-sm rounded-pill" title="Edit IB">
                            <i class="fas fa-edit"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php if(!empty($node['children'])): ?>
                <ul class="tree">
                    <?php echo $__env->make('admin.partials.ib-tree-children', ['children' => $node['children']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            <?php endif; ?>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>

<style>
    /* Tree Styling */
    .tree {
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding: 0;
        margin: 0;
        white-space: nowrap;
        position: relative;
        text-align: center;
        width: 100%;
        transition: all 0.5s ease-in-out;
    }

    .tree ul {
        padding-top: 50px;
        position: relative;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-left: 0;
        margin-bottom: 20px;
        width: 100%;
    }

    .tree li {
        list-style-type: none;
        text-align: center;
        position: relative;
        padding: 20px 5px 0 5px;
        display: inline-flex;
        flex-direction: column;
        align-items: center;
        transition: all 0.5s ease;
        margin: 0 15px;
        flex-grow: 1;
        min-width: 150px;
    }

    /* Connector lines between nodes */
    .tree li::before,
    .tree li::after {
        content: '';
        position: absolute;
        top: 0;
        right: 50%;
        border-top: 2px solid #bbb;
        width: 50%;
        height: 20px;
    }

    .tree li::after {
        left: 50%;
        border-left: 2px solid #bbb;
    }

    .tree li:only-child::after,
    .tree li:only-child::before {
        display: none;
    }

    .tree li:first-child::before,
    .tree li:last-child::after {
        border: 0 none;
    }

    .tree li:last-child::before {
        border-right: 2px solid #bbb;
        border-radius: 0 5px 0 0;
    }

    .tree li:first-child::after {
        border-radius: 5px 0 0 0;
    }

    /* Styling for Node */
    .tree-node {
        border: 3px solid #007bff;
        padding: 20px 20px;
        border-radius: 15px;
        background: linear-gradient(145deg, #f9f9f9, #e9ecef);
        box-shadow: 0px 12px 30px rgba(0, 0, 0, 0.15);
        transition: transform 0.4s ease-in-out, box-shadow 0.4s ease-in-out;
        position: relative;
        animation: fadeIn 1s ease-in-out;
    }

    .tree-node:hover {
        transform: scale(1.1);
        box-shadow: 0px 20px 40px rgba(0, 0, 0, 0.25);
        cursor: pointer;
    }

    /* Node Content Styling */
    .node-content {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
    }

    /* Icon Styling */
    .node-icon {
        margin-bottom: 8px;
    }

    .bi-person-circle {
        font-size: 3rem;
    }

    /* Node Details Styling */
    .node-details {
        text-align: center;
        font-size: 1rem;
        color: #333;
    }

    .node-name {
        font-size: 1.2rem;
        font-weight: 700;
        color: #007bff;
        margin-bottom: 5px;
    }

    .node-email,
    .node-level {
        font-size: 0.85rem;
        color: #6c757d;
    }

    /* Status Badge Styling */
    .node-badge {
        font-size: 0.8rem;
        padding: 6px 15px;
        border-radius: 20px;
        font-weight: bold;
        margin-top: 10px;
        display: inline-block;
    }

    .node-badge-active {
        background: linear-gradient(145deg, #28a745, #218838);
        color: #fff;
    }

    .node-badge-inactive {
        background: linear-gradient(145deg, #dc3545, #c82333);
        color: #fff;
    }

    /* Node Actions Styling */
    .node-actions {
        margin-top: 10px;
        display: flex;
        gap: 10px;
    }

    .btn {
        border-radius: 12px;
        font-size: 0.8rem;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        transition: all 0.3s ease;
        padding: 6px 12px;
    }

    .btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.25);
    }

    .btn-gradient-primary {
        background: linear-gradient(135deg, #007bff, #0056b3);
        color: #fff;
        border: none;
    }

    .btn-gradient-secondary {
        background: linear-gradient(135deg, #6c757d, #5a6268);
        color: #fff;
        border: none;
    }

    /* Styling to balance nodes evenly across */
    .tree-node-wrapper {
        flex: 1 1 auto;
        max-width: 200px;
        display: flex;
        justify-content: center;
    }

    .tree ul::before {
        content: '';
        position: absolute;
        top: 0;
        left: 50%;
        border-left: 2px solid #bbb;
        width: 0;
        height: 20px;
    }

    /* Responsive Styles */
    @media (max-width: 768px) {
        .node-icon {
            font-size: 2rem;
        }

        .node-name {
            font-size: 1rem;
        }

        .btn {
            padding: 5px;
            font-size: 0.7rem;
        }

        .tree ul {
            flex-direction: column;
        }

        .tree li {
            width: auto;
        }
    }

    /* Keyframes for Animations */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: scale(0.8);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Tooltip Functionality
        const nodes = document.querySelectorAll('.tree-node[data-toggle="tooltip"]');
        nodes.forEach(node => {
            node.addEventListener('mouseenter', function () {
                const tooltipText = this.getAttribute('data-tooltip');
                this.setAttribute('title', tooltipText);
            });
        });

        // Optional: Highlight currently active node for better visibility
        const currentNode = document.querySelector('.tree li div.tree-node');
        if (currentNode) {
            currentNode.classList.add('border-success');
        }
    });
</script>
<?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\partials\ib-tree-children.blade.php ENDPATH**/ ?>