

<?php $__env->startSection('title', 'Update IB Status'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="text-primary text-center"><i class="fas fa-user-edit me-2"></i> Update IB Status</h2>

    <div class="card mt-4 shadow-sm border-0">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0"><i class="fas fa-user-cog me-2"></i> IB Details</h4>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <strong>Name:</strong> <span class="text-muted"><?php echo e($ib->name); ?></span>
                </div>
                <div class="col-md-6 mb-3">
                    <strong>Email:</strong> <span class="text-muted"><?php echo e($ib->email); ?></span>
                </div>
                <div class="col-md-6 mb-3">
                    <strong>Current Status:</strong> 
                    <span class="badge bg-<?php echo e($ib->is_active ? 'success' : 'danger'); ?>">
                        <?php echo e($ib->is_active ? 'Active' : 'Inactive'); ?>

                    </span>
                </div>
                <div class="col-md-6 mb-3">
                    <strong>Joined On:</strong> <span class="text-muted"><?php echo e($ib->created_at->format('d M, Y')); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4 shadow-sm border-0">
        <div class="card-header bg-secondary text-white">
            <h4 class="mb-0"><i class="fas fa-edit me-2"></i> Update Status</h4>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.ib.updateStatus', $ib->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>

                <div class="mb-3">
                    <label for="status" class="form-label"><strong>Status</strong></label>
                    <select name="is_active" id="status" class="form-select">
                        <option value="1" <?php echo e($ib->is_active ? 'selected' : ''); ?>>Active</option>
                        <option value="0" <?php echo e(!$ib->is_active ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="admin_remark" class="form-label"><strong>Admin Remark</strong></label>
                    <textarea name="admin_remark" id="admin_remark" class="form-control" rows="4" placeholder="Provide reason or notes (optional)"><?php echo e(old('admin_remark', $ib->admin_remark)); ?></textarea>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i> Update Status
                    </button>
                </div>
            </form>
        </div>
    </div>

    <a href="<?php echo e(route('admin.ib.management')); ?>" class="btn btn-secondary mt-4">
        <i class="fas fa-arrow-left me-2"></i> Back to IB Management
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\ib\updateStatus.blade.php ENDPATH**/ ?>