

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4">Your Trades</h1>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-md-8">
            <form method="GET" action="<?php echo e(route('user.trades')); ?>" class="d-flex">
                <select name="status" class="form-select me-2">
                    <option value="">All Statuses</option>
                    <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>Open</option>
                    <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Closed</option>
                </select>
                <input type="text" name="asset" class="form-control me-2" placeholder="Search by Asset" value="<?php echo e(request('asset')); ?>">
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
    </div>

    <!-- Trades Table -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-dark text-white">
            <i class="fas fa-chart-line me-2"></i> Trades
        </div>
        <div class="card-body">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Asset</th>
                        <th>Status</th>
                        <th>Profit/Loss</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($trade->id); ?></td>
                        <td><?php echo e($trade->asset); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($trade->status == 'open' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($trade->status)); ?>

                            </span>
                        </td>
                        <td class="<?php echo e($trade->profit_loss >= 0 ? 'text-success' : 'text-danger'); ?>">
                            $<?php echo e(number_format($trade->profit_loss, 2)); ?>

                        </td>
                        <td><?php echo e($trade->created_at->format('d M Y')); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center">No trades found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($trades->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\trades.blade.php ENDPATH**/ ?>