

<?php $__env->startSection('title', 'IB Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5" style="background: linear-gradient(135deg, #e0f7fa, #ffffff);">
    <!-- Header -->
    <div class="text-center mb-5">
        <h2 class="fw-bold text-gradient">
            <i class="fas fa-chart-line me-2"></i> IB Report
        </h2>
    </div>

    <!-- Total Earnings -->
    <div class="row justify-content-center mb-4">
        <div class="col-md-6 col-lg-4">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-body text-center" style="background: linear-gradient(135deg, #ffffff, #e8f5e9);">
                    <h5 class="fw-bold">Total Earnings</h5>
                    <h3 class="text-success fw-bold">$<?php echo e(number_format($totalEarnings, 2)); ?></h3>
                    <p class="text-muted small">Your total earnings from referrals and IB activities</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Referrals Table -->
    <div class="card shadow-lg border-0 rounded-4 mb-5">
        <div class="card-header text-white bg-gradient-primary rounded-top">
            <h5 class="m-0">
                <i class="fas fa-users me-2"></i> Referrals
            </h5>
        </div>
        <div class="card-body" style="background: linear-gradient(135deg, #ffffff, #f0f4f8);">
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle">
                    <thead class="table-gradient">
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Earnings</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="text-primary fw-bold"><?php echo e($referral->referredUser->name); ?></td>
                                <td class="text-muted"><?php echo e($referral->referredUser->email); ?></td>
                                <td class="text-success fw-bold">$<?php echo e(number_format($referral->earnings, 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted">No referrals found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                <?php echo e($referrals->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>

    <!-- Withdrawal Requests -->
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header text-white bg-gradient-warning rounded-top">
            <h5 class="m-0">
                <i class="fas fa-wallet me-2"></i> Withdrawals
            </h5>
        </div>
        <div class="card-body" style="background: linear-gradient(135deg, #ffffff, #fff8e1);">
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle">
                    <thead class="table-gradient-warning">
                        <tr>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="text-success fw-bold">$<?php echo e(number_format($withdrawal->amount, 2)); ?></td>
                                <td>
                                    <span class="badge <?php echo e($withdrawal->status === 'approved' ? 'bg-gradient-success' : 'bg-gradient-danger'); ?> text-white rounded-pill">
                                        <?php echo e(ucfirst($withdrawal->status)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($withdrawal->created_at->format('d M Y')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center text-muted">No withdrawals found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3">
                <?php echo e($withdrawals->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
</div>

<style>
/* General Layout */
.container {
    max-width: 1400px;
}

/* Gradient Text */
.text-gradient {
    background: -webkit-linear-gradient(45deg, #007bff, #0056b3);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* Card Styling */
.card {
    border-radius: 20px;
    overflow: hidden;
}
.card-header {
    font-size: 1.2rem;
    font-weight: bold;
    text-transform: uppercase;
}

/* Table Styling */
.table-hover tbody tr:hover {
    background: rgba(0, 123, 255, 0.1);
}
.table th, .table td {
    vertical-align: middle;
    font-size: 1rem;
    text-align: center;
    color: #343a40;
}
.table th {
    text-transform: uppercase;
    font-weight: bold;
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: #ffffff;
    border: 1px solid #dee2e6;
}

/* Badge Styling */
.badge {
    font-size: 0.9rem;
    padding: 0.5rem 1rem;
    font-weight: 600;
    text-transform: capitalize;
    border-radius: 12px;
}

/* Buttons */
.btn-outline-primary {
    color: #007bff;
    border-color: #007bff;
    transition: all 0.3s ease-in-out;
}
.btn-outline-primary:hover {
    background-color: #007bff;
    color: white;
}

/* Responsive Design */
@media (max-width: 768px) {
    .card-header h5 {
        font-size: 1rem;
    }
    .btn-outline-primary {
        font-size: 0.9rem;
        padding: 8px 15px;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\ib-reports\index.blade.php ENDPATH**/ ?>