

<?php $__env->startSection('title', 'IB User Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <h2 class="text-primary fw-bold text-center mb-4">
        <i class="fas fa-user-chart me-2"></i> IB User Report
    </h2>

    <!-- Total Earnings -->
    <div class="card my-4 shadow">
        <div class="card-body text-center">
            <h4>Total Earnings</h4>
            <h2 class="text-success">$<?php echo e(number_format($totalEarnings, 2)); ?></h2>
        </div>
    </div>

    <!-- Referrals Table -->
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-primary text-white rounded-top">
            <strong><i class="fas fa-users me-2"></i> Referrals</strong>
        </div>
        <div class="card-body">
            <?php if($referrals->isEmpty()): ?>
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No referrals found.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Referred Name</th>
                                <th>Referred Email</th>
                                <th>Earnings</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $referrals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="text-center">
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($referral->referredUser->name); ?></td>
                                    <td><?php echo e($referral->referredUser->email); ?></td>
                                    <td>$<?php echo e(number_format($referral->earnings, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($referrals->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\ib-reports\show.blade.php ENDPATH**/ ?>