

<?php $__env->startSection('title', 'Create Support Ticket'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow border-0 rounded-4">
                <!-- Card Header -->
                <div class="card-header text-white text-center py-3" style="background: linear-gradient(135deg, #4a90e2, #007bff);">
                    <h3 class="m-0">
                        <i class="fas fa-ticket-alt me-2"></i> Create Support Ticket
                    </h3>
                </div>
                <!-- Card Body -->
                <div class="card-body p-4" style="background: linear-gradient(135deg, #f8f9fa, #ffffff);">
                    <form method="POST" action="<?php echo e(route('user.support.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <!-- Subject Input -->
                        <div class="form-floating mb-4">
                            <input type="text" name="subject" id="subject" class="form-control shadow-sm" placeholder="Enter Subject" required>
                            <label for="subject">
                                <i class="fas fa-heading me-2"></i> Subject
                            </label>
                        </div>

                        <!-- Description Input -->
                        <div class="form-floating mb-4">
                            <textarea name="description" id="description" class="form-control shadow-sm" placeholder="Enter Description" style="height: 150px;" required></textarea>
                            <label for="description">
                                <i class="fas fa-align-left me-2"></i> Description
                            </label>
                        </div>

                        <!-- Priority Selection -->
                        <div class="form-floating mb-4">
                            <select name="priority" id="priority" class="form-select shadow-sm">
                                <option value="low">Low</option>
                                <option value="medium" selected>Medium</option>
                                <option value="high">High</option>
                            </select>
                            <label for="priority">
                                <i class="fas fa-exclamation-circle me-2"></i> Priority
                            </label>
                        </div>

                        <!-- File Upload -->
                        <div class="mb-4">
                            <label for="attachments" class="form-label">
                                <i class="fas fa-paperclip me-2"></i> Attach Files (Images/Documents)
                            </label>
                            <input type="file" name="attachments[]" id="attachments" class="form-control shadow-sm" multiple>
                            <small class="text-muted">You can upload multiple files. Accepted formats: JPG, PNG, PDF, DOCX.</small>
                        </div>

                        <!-- Submit Button -->
                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-gradient-primary shadow px-5 py-2 rounded-pill">
                                <i class="fas fa-paper-plane me-2"></i> Submit Ticket
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Styling same as before */
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\support\create.blade.php ENDPATH**/ ?>