

<?php $__env->startSection('title', 'Edit Commission Level'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary text-center fw-bold">
        <i class="fas fa-edit me-2"></i> Edit Commission Level
    </h2>

    <div class="card shadow-lg border-0 mb-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white rounded-top">
            <strong><i class="fas fa-cogs me-2"></i> Update Commission Level Details</strong>
        </div>
        <div class="card-body bg-light p-4">
            <form action="<?php echo e(route('admin.ib-commission-levels.update', $commissionLevel->id)); ?>" method="POST" class="needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-3">
                    <label for="level" class="form-label fw-bold">Level <span class="text-danger">*</span></label>
                    <input type="number" name="level" id="level" class="form-control shadow-sm rounded-pill" value="<?php echo e(old('level', $commissionLevel->level)); ?>" required>
                    <div class="invalid-feedback">
                        Please provide the commission level.
                    </div>
                </div>

                <div class="mb-3">
                    <label for="commission_percentage" class="form-label fw-bold">Commission Percentage (%) <span class="text-danger">*</span></label>
                    <input type="number" name="commission_percentage" id="commission_percentage" class="form-control shadow-sm rounded-pill" value="<?php echo e(old('commission_percentage', $commissionLevel->commission_percentage)); ?>" required min="0" max="100" step="0.01">
                    <div class="invalid-feedback">
                        Please provide a valid commission percentage (0-100).
                    </div>
                </div>

                <button type="submit" class="btn btn-success shadow-sm rounded-pill"><i class="fas fa-save me-2"></i> Save Changes</button>
                <a href="<?php echo e(route('admin.ib-commission-levels.index')); ?>" class="btn btn-outline-secondary shadow-sm rounded-pill"><i class="fas fa-arrow-left me-2"></i> Cancel</a>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.querySelector('.needs-validation');
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\ib-commission-levels\edit.blade.php ENDPATH**/ ?>