@extends('layouts.app')

@section('title', 'Support Tickets')

@section('content')
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-primary fw-bold">
            <i class="fas fa-life-ring me-2"></i> My Support Tickets
        </h2>
        <a href="{{ route('user.support.create') }}" class="btn btn-gradient-primary shadow-sm rounded-pill px-4">
            <i class="fas fa-plus me-2"></i> New Ticket
        </a>
    </div>

    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="m-0"><i class="fas fa-ticket-alt me-2"></i> Tickets</h5>
            <form class="d-flex" method="GET" action="{{ route('user.support.index') }}">
                <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Search tickets..." value="{{ request('search') }}">
                <button type="submit" class="btn btn-light btn-sm">
                    <i class="fas fa-search"></i>
                </button>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tickets as $ticket)
                            <tr>
                                <td class="fw-bold text-primary">#{{ $ticket->id }}</td>
                                <td>{{ $ticket->subject }}</td>
                                <td>
                                    <span class="badge 
                                        @if($ticket->status == 'open') bg-primary 
                                        @elseif($ticket->status == 'in_progress') bg-warning text-dark 
                                        @elseif($ticket->status == 'completed') bg-success 
                                        @elseif($ticket->status == 'closed') bg-danger 
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                                    </span>
                                </td>
                                <td>{{ $ticket->created_at->format('d M Y, H:i') }}</td>
                                <td class="text-center">
                                    <a href="{{ route('user.support.show', $ticket->id) }}" class="btn btn-sm btn-info shadow-sm rounded-pill px-3">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">
                                    <i class="fas fa-info-circle me-2"></i> No support tickets found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($tickets->hasPages())
                <div class="mt-3 d-flex justify-content-end">
                    {{ $tickets->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
</div>

<style>
/* General Styles */
.container {
    max-width: 1200px;
}

/* Table Styling */
.table-hover tbody tr:hover {
    background-color: rgba(0, 123, 255, 0.1);
}
.table th, .table td {
    vertical-align: middle;
}
.badge {
    font-size: 0.85rem;
    padding: 6px 12px;
    font-weight: 600;
    text-transform: capitalize;
}

/* Buttons */
.btn-gradient-primary {
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: #fff;
    border: none;
    transition: all 0.3s ease-in-out;
}
.btn-gradient-primary:hover {
    background: linear-gradient(135deg, #0056b3, #003f7f);
    color: #fff;
}

/* Responsive Design */
@media (max-width: 768px) {
    .table th, .table td {
        font-size: 0.85rem;
    }
    .btn-gradient-primary {
        font-size: 0.85rem;
        padding: 6px 10px;
    }
}
</style>
@endsection
