@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Simulated Payment Gateway</div>

                <div class="card-body">
                    <p>Transaction ID: {{ $transaction->id }}</p>
                    <p>Amount: ${{ number_format($transaction->amount, 2) }}</p>

                    <form action="{{ route('wallet.payment.callback', ['transactionId' => $transaction->id]) }}" method="GET">
                        <button type="submit" class="btn btn-success">Simulate Successful Payment</button>
                    </form>

                    <a href="{{ route('wallet.index') }}" class="btn btn-secondary mt-3">Cancel</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
