@extends('layouts.app')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="fw-bold text-primary">
                <i class="fas fa-user-friends me-2"></i> Referral Dashboard
            </h2>
            <p class="text-muted">Track your referrals, earnings, and growth with an interactive dashboard.</p>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="row g-4">
        <!-- Referral Link -->
        <div class="col-lg-4 col-md-6">
            <div class="card shadow-lg border-0 bg-gradient-primary text-light rounded-3 hover-scale">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="fw-bold mb-3"><i class="fas fa-link me-2"></i>Your Referral Link</h5>
                    <div class="input-group">
                        <input type="text" id="referralLink" class="form-control bg-light text-dark border-0" value="{{ $referralLink }}" readonly>
                        <button class="btn btn-light btn-sm" onclick="copyReferralLink()">Copy</button>
                    </div>
                    <small class="text-light mt-2">Share this link to invite others and earn rewards!</small>
                </div>
            </div>
        </div>

        <!-- Total Earnings -->
        <div class="col-lg-4 col-md-6">
            <div class="card shadow-lg border-0 bg-gradient-success text-white rounded-3 hover-scale">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="fw-bold mb-3"><i class="fas fa-dollar-sign me-2"></i>Total Earnings</h5>
                    <h3 class="mb-0">${{ number_format($totalEarnings, 2) }}</h3>
                </div>
            </div>
        </div>

        <!-- Total Referrals -->
        <div class="col-lg-4 col-md-6">
            <div class="card shadow-lg border-0 bg-gradient-warning text-dark rounded-3 hover-scale">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="fw-bold mb-3"><i class="fas fa-users me-2"></i>Total Referrals</h5>
                    <h3 class="mb-0">{{ $referrals->count() }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Referral Growth Chart -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-lg border-0 rounded-3 hover-scale">
                <div class="card-header bg-gradient-primary text-white">
                    <strong><i class="fas fa-chart-line me-2"></i> Referral Growth</strong>
                </div>
                <div class="card-body">
                    <canvas id="referralGrowthChart" style="height: 300px;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Referrals Table -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-lg border-0 rounded-3 hover-scale">
                <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
                    <strong><i class="fas fa-users me-2"></i> Referred Users</strong>
                    <span class="badge bg-light text-dark">{{ $referrals->count() }} Total</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-primary">
                                <tr class="text-center">
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Date Registered</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($referrals as $referral)
                                    <tr class="text-center">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $referral->referredUser->name }}</td>
                                        <td>{{ $referral->referredUser->email }}</td>
                                        <td>{{ $referral->referredUser->created_at->format('d M Y') }}</td>
                                        <td>
                                            <span class="badge {{ $referral->referredUser->is_active ? 'bg-success' : 'bg-danger' }}">
                                                {{ $referral->referredUser->is_active ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">No referrals yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-3">
                        {{ $referrals->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    body {
        background-color: #f8f9fa;
    }

    .hover-scale {
        transition: all 0.3s ease-in-out;
    }

    .hover-scale:hover {
        transform: scale(1.02);
    }

    .bg-gradient-primary {
        background: linear-gradient(45deg, #007bff, #0056b3);
    }

    .bg-gradient-success {
        background: linear-gradient(45deg, #28a745, #1c7c31);
    }

    .bg-gradient-warning {
        background: linear-gradient(45deg, #ffc107, #e0a800);
    }

    .text-primary {
        color: #007bff !important;
    }

    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.1);
    }

    @media (max-width: 768px) {
        .card-body {
            padding: 1rem;
        }
    }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    function copyReferralLink() {
        const referralLink = document.getElementById('referralLink');
        referralLink.select();
        navigator.clipboard.writeText(referralLink.value).then(() => {
            alert('Referral link copied to clipboard!');
        });
    }

    // Chart Configuration
    document.addEventListener('DOMContentLoaded', function () {
        const ctx = document.getElementById('referralGrowthChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: {!! json_encode(array_column($growthData, 'month')) !!},
                datasets: [{
                    label: 'Referrals',
                    data: {!! json_encode(array_column($growthData, 'count')) !!},
                    backgroundColor: 'rgba(0, 123, 255, 0.2)',
                    borderColor: '#007bff',
                    borderWidth: 2,
                    tension: 0.4,
                    fill: true,
                    pointBackgroundColor: '#ffffff',
                    pointBorderColor: '#007bff',
                    pointHoverRadius: 6,
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return `${context.raw} Referrals`;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        ticks: {
                            beginAtZero: true
                        }
                    }
                }
            }
        });
    });
</script>
@endsection
