@extends('layouts.app')

@section('title', 'User Profile')

@section('content')
<div class="container py-5" style="background: linear-gradient(to bottom, #eef2f3, #ffffff);">
    <div class="row justify-content-center">
        <!-- Profile Header -->
        <div class="col-md-10 text-center mb-5">
            <h1 class="fw-bold text-gradient" style="background: linear-gradient(45deg, #4facfe, #00f2fe); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                <i class="fas fa-user-circle me-2"></i> Manage Your Profile
            </h1>
            <p class="text-muted fs-5">Update your profile details, change your password, and manage your account securely.</p>
        </div>

        <!-- Profile Card -->
        <div class="col-md-8">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-header text-white text-center py-4" style="background: linear-gradient(135deg, #6a11cb, #2575fc);">
                    <h4 class="m-0">
                        <i class="fas fa-user-edit me-2"></i> Profile Information
                    </h4>
                </div>
                <div class="card-body p-4" style="background: linear-gradient(to right, #ffffff, #f9f9f9);">
                    <!-- Success Message -->
                    @if(session('success'))
                        <div class="alert alert-success text-center shadow-sm rounded-pill">
                            <i class="fas fa-check-circle me-2"></i> {{ session('success') }}
                        </div>
                    @endif

                    <!-- Profile Form -->
                    <form action="{{ route('profile.update') }}" method="POST" class="row g-3">
                        @csrf
                        <!-- Name Field -->
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-bold">Name</label>
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-gradient-primary text-white">
                                    <i class="fas fa-user"></i>
                                </span>
                                <input type="text" name="name" id="name" class="form-control" value="{{ old('name', $user->name) }}" placeholder="Your Name" required>
                            </div>
                        </div>

                        <!-- Email Field -->
                        <div class="col-md-6">
                            <label for="email" class="form-label fw-bold">Email</label>
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-gradient-primary text-white">
                                    <i class="fas fa-envelope"></i>
                                </span>
                                <input type="email" name="email" id="email" class="form-control" value="{{ old('email', $user->email) }}" placeholder="Your Email" required>
                            </div>
                        </div>

                        <!-- Password Field -->
                        <div class="col-md-6">
                            <label for="password" class="form-label fw-bold">New Password</label>
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-gradient-primary text-white">
                                    <i class="fas fa-lock"></i>
                                </span>
                                <input type="password" name="password" id="password" class="form-control" placeholder="New Password">
                            </div>
                            <small class="text-muted">Leave blank to keep your current password.</small>
                        </div>

                        <!-- Confirm Password Field -->
                        <div class="col-md-6">
                            <label for="password_confirmation" class="form-label fw-bold">Confirm Password</label>
                            <div class="input-group shadow-sm">
                                <span class="input-group-text bg-gradient-primary text-white">
                                    <i class="fas fa-lock"></i>
                                </span>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="Confirm Password">
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="col-12 text-center mt-4">
                            <button type="submit" class="btn btn-gradient-primary shadow px-5 py-2 rounded-pill">
                                <i class="fas fa-save me-2"></i> Update Profile
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* General Styling */
.container {
    max-width: 1200px;
}

/* Gradient Text */
.text-gradient {
    background: linear-gradient(45deg, #6a11cb, #2575fc);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

/* Card Styling */
.card {
    border-radius: 20px;
    overflow: hidden;
}
.card-header {
    font-size: 1.4rem;
    font-weight: bold;
    text-transform: uppercase;
}

/* Input Group */
.input-group-text {
    border-radius: 0;
    font-size: 1.2rem;
}
.form-control {
    border-radius: 0;
    font-size: 1rem;
    box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
}

/* Button Styling */
.btn-gradient-primary {
    background: linear-gradient(135deg, #6a11cb, #2575fc);
    color: #fff;
    border: none;
    transition: all 0.3s ease-in-out;
}
.btn-gradient-primary:hover {
    background: linear-gradient(135deg, #2575fc, #6a11cb);
    color: #fff;
}

/* Success Alert */
.alert-success {
    font-size: 1rem;
    font-weight: bold;
    border-radius: 12px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .card-header {
        font-size: 1.2rem;
    }
    .btn-gradient-primary {
        font-size: 1rem;
    }
}
</style>
@endsection
