@extends('layouts.app')

@section('title', 'MT5 Trades')

@section('content')
<div class="container-fluid px-4">
    <h2 class="mt-4">My Trades</h2>

    <!-- Display Success and Error Messages -->
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <!-- Trades Table -->
    <div class="card">
        <div class="card-body">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Trade ID</th>
                        <th>Asset</th>
                        <th>Volume</th>
                        <th>Type</th>
                        <th>Profit/Loss</th>
                        <th>Status</th>
                        <th>Opened At</th>
                        <th>Closed At</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($trades as $trade)
                        <tr>
                            <td>{{ $trade['trade_id'] }}</td>
                            <td>{{ $trade['asset'] }}</td>
                            <td>{{ $trade['volume'] }}</td>
                            <td>{{ ucfirst($trade['type']) }}</td>
                            <td class="{{ $trade['profit'] >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ $trade['profit'] }}
                            </td>
                            <td>{{ ucfirst($trade['status']) }}</td>
                            <td>{{ $trade['opened_at'] ?? 'N/A' }}</td>
                            <td>{{ $trade['closed_at'] ?? 'N/A' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center">No trades found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
