@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4 text-center text-primary">KYC Submission</h2>

    <!-- KYC Status Alert -->
    @if($kyc && $kyc->status !== 'pending')
        <div class="alert alert-{{ $kyc->status === 'approved' ? 'success' : 'danger' }}">
            <strong>Your KYC is {{ ucfirst($kyc->status) }}.</strong>
            @if($kyc->admin_remark)
                <p><strong>Admin Remark:</strong> {{ $kyc->admin_remark }}</p>
            @endif
        </div>
    @endif

    <!-- KYC Progress Bar -->
    @if($kyc)
        <div class="progress mb-4">
            <div class="progress-bar bg-{{ $kyc->status === 'approved' ? 'success' : ($kyc->status === 'rejected' ? 'danger' : 'warning') }}" 
                 role="progressbar" 
                 style="width: {{ $kyc->status === 'approved' ? '100%' : ($kyc->status === 'rejected' ? '100%' : '50%') }}%;" 
                 aria-valuenow="{{ $kyc->status === 'approved' ? '100' : ($kyc->status === 'rejected' ? '100' : '50') }}" 
                 aria-valuemin="0" 
                 aria-valuemax="100">
                {{ ucfirst($kyc->status) }}
            </div>
        </div>
    @endif

    <!-- KYC Form -->
    <form action="{{ route('user.kyc.submit') }}" method="POST" enctype="multipart/form-data" id="kycForm">
        @csrf
        <div class="card shadow-sm border-0">
            <div class="card-header bg-dark text-white">
                <i class="fas fa-id-card me-2"></i> Upload Your Documents
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="passport" class="form-label">Passport</label>
                    <input type="file" class="form-control" id="passport" name="passport">
                </div>
                <div class="mb-3">
                    <label for="driver_license" class="form-label">Driver License</label>
                    <input type="file" class="form-control" id="driver_license" name="driver_license">
                </div>
                <div class="mb-3">
                    <label for="nid" class="form-label">NID</label>
                    <input type="file" class="form-control" id="nid" name="nid">
                </div>
                <div class="mb-3">
                    <label for="other_documents" class="form-label">Other Documents</label>
                    <input type="file" class="form-control" id="other_documents" name="other_documents">
                </div>
            </div>
            <div class="card-footer text-end">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-upload me-1"></i> Submit
                </button>
            </div>
        </div>
    </form>
</div>

@endsection

@push('styles')
<style>
    .progress {
        height: 25px;
    }
    .progress-bar {
        font-size: 14px;
        font-weight: bold;
        line-height: 25px;
    }
    .card-header {
        font-size: 18px;
        font-weight: bold;
    }
    .btn-success {
        background: linear-gradient(45deg, #28a745, #218838);
        border: none;
    }
    .btn-success:hover {
        background: linear-gradient(45deg, #218838, #28a745);
    }
</style>
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', () => {
        // Enhance user experience with custom script (if needed)
    });
</script>
@endpush
