@extends('layouts.app')

@section('title', 'IB Dashboard')

@section('content')
<div class="container-fluid mt-4">
    <!-- Page Title -->
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="text-primary fw-bold">
                <i class="fas fa-network-wired me-2"></i> IB Dashboard
            </h2>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm border-0 bg-gradient-primary text-white rounded-3 hover-effect">
                <div class="card-body d-flex align-items-center p-3">
                    <div class="icon me-3">
                        <i class="fas fa-users fa-lg"></i>
                    </div>
                    <div class="text">
                        <h6 class="fw-bold mb-1">Total Referrals</h6>
                        <h4 class="mb-0">{{ $totalReferralsCount }}</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm border-0 bg-gradient-success text-white rounded-3 hover-effect">
                <div class="card-body d-flex align-items-center p-3">
                    <div class="icon me-3">
                        <i class="fas fa-user-plus fa-lg"></i>
                    </div>
                    <div class="text">
                        <h6 class="fw-bold mb-1">Direct Referrals</h6>
                        <h4 class="mb-0">{{ $directReferralsCount }}</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm border-0 bg-gradient-warning text-dark rounded-3 hover-effect">
                <div class="card-body d-flex align-items-center p-3">
                    <div class="icon me-3">
                        <i class="fas fa-dollar-sign fa-lg"></i>
                    </div>
                    <div class="text">
                        <h6 class="fw-bold mb-1">Total Earnings</h6>
                        <h4 class="mb-0">${{ number_format($totalEarnings, 2) }}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Direct Referrals Table -->
    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
            <strong><i class="fas fa-users me-2"></i> Direct Referrals</strong>
            <a href="{{ route('user.ib.tree') }}" class="btn btn-light btn-sm shadow-sm rounded-pill">
                <i class="fas fa-sitemap me-2"></i> View Tree
            </a>
        </div>
        <div class="card-body p-3">
            @if ($referrals->isEmpty())
                <div class="alert alert-info text-center mt-3">
                    <i class="fas fa-info-circle me-2"></i> No referrals found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0" id="referralsTable">
                        <thead class="table-primary">
                            <tr class="text-center">
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Total Referrals</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="border-top">
                            @foreach ($referrals as $referral)
                                @if($referral->referredUser)
                                    <tr class="text-center table-row-hover">
                                        <td>{{ $referral->referredUser->id }}</td>
                                        <td>{{ $referral->referredUser->name }}</td>
                                        <td>{{ $referral->referredUser->email }}</td>
                                        <td>{{ $referral->referredUser->referrals->count() }}</td>
                                        <td>
                                            <a href="{{ route('user.ib.tree') }}" class="btn btn-outline-primary btn-sm shadow-sm rounded-pill">
                                                <i class="fas fa-sitemap"></i> View Tree
                                            </a>
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <nav>
                        <ul class="pagination pagination-sm" id="pagination"></ul>
                    </nav>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
    /* Page Styling */
    body {
        background-color: #f8f9fa;
    }

    .hover-effect {
        transition: all 0.3s ease-in-out;
    }

    .hover-effect:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .icon {
        font-size: 2rem;
    }

    /* Table Row Hover */
    .table-row-hover:hover {
        background-color: rgba(0, 123, 255, 0.1);
        cursor: pointer;
    }

    /* Pagination */
    .pagination .page-item .page-link {
        border-radius: 50%;
        color: #007bff;
        padding: 0.4rem 0.6rem;
    }

    .pagination .page-item.active .page-link {
        background-color: #007bff;
        color: #fff;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .card-body.p-3 {
            padding: 1rem;
        }

        .table-responsive {
            margin-bottom: 1rem;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rowsPerPage = 5;
        const table = document.querySelector("#referralsTable tbody");
        const rows = Array.from(table.rows);
        const pagination = document.querySelector("#pagination");

        function displayPage(page) {
            const start = (page - 1) * rowsPerPage;
            const end = start + rowsPerPage;

            rows.forEach((row, index) => {
                row.style.display = index >= start && index < end ? '' : 'none';
            });
        }

        function setupPagination() {
            const totalPages = Math.ceil(rows.length / rowsPerPage);
            pagination.innerHTML = '';

            for (let i = 1; i <= totalPages; i++) {
                const li = document.createElement("li");
                li.className = "page-item";
                li.innerHTML = `<a class="page-link" href="#">${i}</a>`;
                li.addEventListener("click", function (e) {
                    e.preventDefault();
                    displayPage(i);

                    document.querySelectorAll("#pagination .page-item").forEach(item => {
                        item.classList.remove("active");
                    });
                    li.classList.add("active");
                });
                pagination.appendChild(li);
            }

            pagination.querySelector(".page-item:first-child")?.classList.add("active");
        }

        displayPage(1);
        setupPagination();
    });
</script>
@endsection
