@extends('layouts.admin')

@section('title', 'Edit User')

@section('content')
<div class="container-fluid px-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <h1 class="mt-4 mb-4 text-center text-primary"><i class="fas fa-user-edit me-2"></i>Edit User</h1>

            <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="card shadow-lg border-0 rounded">
                    <div class="card-header bg-gradient-primary text-white">
                        <h4 class="mb-0"><i class="fas fa-user me-2"></i> User Details</h4>
                    </div>

                    <div class="card-body">
                        <!-- User Name -->
                        <div class="form-group mb-4">
                            <label for="name" class="form-label"><i class="fas fa-user me-2"></i>Name</label>
                            <input type="text" name="name" id="name" class="form-control form-control-lg shadow-sm" value="{{ old('name', $user->name) }}" required>
                        </div>

                        <!-- User Email -->
                        <div class="form-group mb-4">
                            <label for="email" class="form-label"><i class="fas fa-envelope me-2"></i>Email</label>
                            <input type="email" name="email" id="email" class="form-control form-control-lg shadow-sm" value="{{ old('email', $user->email) }}" required>
                        </div>

                        <!-- User Role -->
                        <div class="form-group mb-4">
                            <label for="role" class="form-label"><i class="fas fa-user-tag me-2"></i>Role</label>
                            <select name="role" id="role" class="form-select form-select-lg shadow-sm" required>
                                @foreach($roles as $role)
                                    <option value="{{ $role->name }}" {{ in_array($role->name, $user->roles->pluck('name')->toArray()) ? 'selected' : '' }}>
                                        {{ ucfirst($role->name) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- User Active Status -->
                        <div class="form-group mb-4 d-flex align-items-center">
                            <label for="is_active" class="form-label me-4"><i class="fas fa-user-check me-2"></i>Active Status</label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="is_active" value="0">
                                <input type="checkbox" class="form-check-input form-control-lg shadow-sm" name="is_active" id="is_active" value="1" {{ $user->is_active ? 'checked' : '' }}>
                                <label class="form-check-label ms-2 fw-bold" for="is_active" id="statusLabel">{{ $user->is_active ? 'Enabled' : 'Disabled' }}</label>
                            </div>
                        </div>

                        <!-- Reset Password -->
                        <div class="form-group mb-4">
                            <label for="password" class="form-label"><i class="fas fa-lock me-2"></i>Reset Password</label>
                            <input type="password" name="password" id="password" class="form-control form-control-lg shadow-sm" placeholder="Enter new password (optional)">
                            <small class="text-muted">Leave blank if you don't want to change the password.</small>
                        </div>
                    </div>

                    <div class="card-footer d-flex justify-content-between">
                        <a href="{{ route('admin.users') }}" class="btn btn-secondary btn-lg shadow-sm">
                            <i class="fas fa-arrow-left me-2"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-success btn-lg shadow-sm">
                            <i class="fas fa-save me-2"></i> Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Role Management Modal -->
@if(isset($roles) && $roles->isNotEmpty())
    <div class="modal fade" id="roleManagementModal" tabindex="-1" aria-labelledby="roleManagementModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('admin.users.updateRole') }}" method="POST">
                @csrf
                <div class="modal-content shadow-lg">
                    <div class="modal-header bg-gradient-primary text-white">
                        <h5 class="modal-title" id="roleManagementModalLabel"><i class="fas fa-user-cog me-2"></i>Manage User Roles</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="modalUserId" value="">
                        <div class="form-group">
                            <label for="roles" class="fw-bold">Assign Roles</label>
                            <select name="roles[]" id="roles" class="form-select form-select-lg shadow-sm" multiple>
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}" {{ in_array($role->id, $user->roles->pluck('id')->toArray()) ? 'selected' : '' }}>
                                        {{ ucfirst($role->name) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary shadow-sm">
                            <i class="fas fa-save"></i> Save Changes
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@else
    <div class="alert alert-info mt-4">
        <i class="fas fa-info-circle me-2"></i> No roles available for assignment. Please add roles in the Role Management section.
    </div>
@endif

<script>
    // JavaScript to pass user data to the modal for role management
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.manage-role-btn').forEach(button => {
            button.addEventListener('click', function () {
                const userId = this.getAttribute('data-user-id');
                document.getElementById('modalUserId').value = userId;
            });
        });

        // Update the label for active status switch
        const statusToggle = document.getElementById('is_active');
        const statusLabel = document.getElementById('statusLabel');
        statusToggle.addEventListener('change', function () {
            if (statusToggle.checked) {
                statusLabel.innerText = 'Enabled';
            } else {
                statusLabel.innerText = 'Disabled';
            }
        });
    });
</script>
@endsection
