@extends('layouts.admin')

@section('title', 'Manage Roles')

@section('content')
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary"><i class="fas fa-tools"></i> Manage Roles</h2>

    <!-- Roles Table Section -->
    <div class="card shadow-lg border-0 rounded">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="mb-0"><i class="fas fa-list"></i> Role List</h5>
            <a href="{{ route('admin.roles.create') }}" class="btn btn-light btn-sm shadow-sm">
                <i class="fas fa-user-plus"></i> Add New Role
            </a>
        </div>
        <div class="card-body">
            @if($roles->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle"></i> No roles found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-primary">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Name</th>
                                <th>Permissions</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="border-top">
                            @foreach($roles as $role)
                                <tr class="text-center">
                                    <td>{{ $role->id }}</td>
                                    <td>{{ ucfirst($role->name) }}</td>
                                    <td>{{ $role->permissions->pluck('name')->join(', ') }}</td>
                                    <td>
                                        <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-warning btn-sm shadow-sm">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>

                                        <a href="{{ route('admin.roles.showUsers', $role->id) }}" class="btn btn-info btn-sm shadow-sm">
                                            <i class="fas fa-users"></i> Show Users
                                        </a>

                                        <form action="{{ route('admin.roles.delete', $role->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this role?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm shadow-sm">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $roles->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
