@extends('layouts.admin')

@section('title', 'Admin Reports')

@section('content')
<div class="container-fluid px-4">

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="text-primary fw-bold">Admin Reports</h1>
    </div>

    <!-- Summary Cards Section -->
    <div class="row mb-4 g-4">
        @php
            $cardData = [
                ['title' => 'Total Users', 'value' => $totalUsers, 'icon' => 'fas fa-users', 'gradient' => 'linear-gradient(135deg, #3498db, #1abc9c)'],
                ['title' => 'Total Trades', 'value' => $totalTrades, 'icon' => 'fas fa-chart-line', 'gradient' => 'linear-gradient(135deg, #28a745, #4caf50)'],
                ['title' => 'Total Transactions', 'value' => $totalTransactions, 'icon' => 'fas fa-exchange-alt', 'gradient' => 'linear-gradient(135deg, #f1c40f, #f39c12)'],
                ['title' => 'Total Wallet Balance', 'value' => '$' . number_format((float) $totalBalance, 2), 'icon' => 'fas fa-wallet', 'gradient' => 'linear-gradient(135deg, #e74c3c, #c0392b)'],
                ['title' => 'Total Deposits', 'value' => '$' . number_format((float) $totalDeposits, 2), 'icon' => 'fas fa-arrow-circle-down', 'gradient' => 'linear-gradient(135deg, #6c5ce7, #8e44ad)'],
                ['title' => 'Total Withdrawals', 'value' => '$' . number_format((float) $totalWithdrawals, 2), 'icon' => 'fas fa-arrow-circle-up', 'gradient' => 'linear-gradient(135deg, #fd79a8, #ff4757)'],
                ['title' => 'Active Trading Accounts', 'value' => $activeTradingAccounts, 'icon' => 'fas fa-user-cog', 'gradient' => 'linear-gradient(135deg, #00b894, #2ecc71)'],
                ['title' => 'Average Trade Size', 'value' => '$' . number_format((float) $averageTradeSize, 2), 'icon' => 'fas fa-chart-area', 'gradient' => 'linear-gradient(135deg, #ffb142, #ff793f)'],
                ['title' => 'Revenue Analysis', 'value' => '$' . number_format((float) $revenueAnalysis->sum(), 2), 'icon' => 'fas fa-coins', 'gradient' => 'linear-gradient(135deg, #e67e22, #d35400)'],
                ['title' => 'Pending Withdrawals', 'value' => '$' . number_format((float) $pendingWithdrawals, 2), 'icon' => 'fas fa-clock', 'gradient' => 'linear-gradient(135deg, #ff9f43, #ff6b6b)'],
                ['title' => 'Users with Active Trades', 'value' => $usersWithActiveTrades, 'icon' => 'fas fa-user-chart', 'gradient' => 'linear-gradient(135deg, #0984e3, #74b9ff)'],
                ['title' => 'New Users (Last 30 Days)', 'value' => $newUsersLastMonth, 'icon' => 'fas fa-user-plus', 'gradient' => 'linear-gradient(135deg, #55efc4, #00cec9)'],
            ];
        @endphp

        @foreach ($cardData as $card)
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="card shadow-sm border-0" style="height: 100%; background: {{ $card['gradient'] }}; color: white;">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h5 class="card-title">{{ $card['title'] }}</h5>
                                <h2 class="fw-bold">{{ $card['value'] }}</h2>
                            </div>
                            <div>
                                <i class="{{ $card['icon'] }} fa-3x text-white-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Charts Section -->
    <div class="row mb-4">
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-chart-bar me-2"></i> Trades Performance (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="tradesPerDayChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-user-plus me-2"></i> User Signups (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="userSignupsChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-coins me-2"></i> Revenue Analysis (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-chart-pie me-2"></i> Monthly Deposits vs Withdrawals
                </div>
                <div class="card-body">
                    <canvas id="monthlyDepositWithdrawalChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-history me-2"></i> Transaction History (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="transactionHistoryChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Users with Active Wallets Chart -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-wallet me-2"></i> Users with Active Wallet Balances
                </div>
                <div class="card-body">
                    <canvas id="usersWithActiveWalletsChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Transactions Table -->
    <div class="card shadow border-light mt-4">
        <div class="card-header bg-primary text-white">
            <i class="fas fa-table"></i> Recent Transactions
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($recentTransactions as $transaction)
                            <tr>
                                <td>{{ $transaction->id }}</td>
                                <td>{{ $transaction->user->name ?? 'N/A' }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->type === 'deposit' ? 'success' : 'warning' }}">
                                        {{ ucfirst($transaction->type) }}
                                    </span>
                                </td>
                                <td>${{ number_format($transaction->amount, 2) }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->status === 'approved' ? 'success' : ($transaction->status === 'rejected' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($transaction->status) }}
                                    </span>
                                </td>
                                <td>{{ $transaction->created_at->format('Y-m-d, h:i A') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted">No recent transactions found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data for Trades per Day Chart
    const tradesPerDayData = {
        labels: @json(array_keys($tradesPerDay->toArray())),
        datasets: [{
            label: 'Trades Per Day',
            data: @json(array_values($tradesPerDay->toArray())),
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 2,
            fill: true
        }]
    };

    // Trades Per Day Chart
    const ctx1 = document.getElementById('tradesPerDayChart').getContext('2d');
    new Chart(ctx1, {
        type: 'line',
        data: tradesPerDayData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Data for User Signups Chart
    const userSignupsData = {
        labels: @json(array_keys($userSignups->toArray())),
        datasets: [{
            label: 'User Signups',
            data: @json(array_values($userSignups->toArray())),
            backgroundColor: 'rgba(153, 102, 255, 0.2)',
            borderColor: 'rgba(153, 102, 255, 1)',
            borderWidth: 2,
            fill: true
        }]
    };

    // User Signups Chart
    const ctx2 = document.getElementById('userSignupsChart').getContext('2d');
    new Chart(ctx2, {
        type: 'line',
        data: userSignupsData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Revenue Analysis Chart
    const revenueData = {
        labels: @json(array_keys($revenueAnalysis->toArray())),
        datasets: [{
            label: 'Revenue',
            data: @json(array_values($revenueAnalysis->toArray())),
            backgroundColor: 'rgba(255, 206, 86, 0.2)',
            borderColor: 'rgba(255, 206, 86, 1)',
            borderWidth: 2
        }]
    };

    const ctx3 = document.getElementById('revenueChart').getContext('2d');
    new Chart(ctx3, {
        type: 'line',
        data: revenueData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Data for Monthly Deposit vs Withdrawal Chart
    const monthlyDepositWithdrawalData = {
        labels: ['Deposits', 'Withdrawals'],
        datasets: [{
            label: 'Total Amount',
            data: [{{ $totalDeposits }}, {{ $totalWithdrawals }}],
            backgroundColor: [
                'rgba(75, 192, 192, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(75, 192, 192, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 2
        }]
    };

    // Monthly Deposits vs Withdrawals Chart
    const ctx4 = document.getElementById('monthlyDepositWithdrawalChart').getContext('2d');
    new Chart(ctx4, {
        type: 'pie',
        data: monthlyDepositWithdrawalData,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });

    // Transaction History Chart
    const transactionHistoryData = {
        labels: @json(array_keys($transactionHistory->toArray())),
        datasets: [{
            label: 'Transactions',
            data: @json(array_values($transactionHistory->toArray())),
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor: 'rgba(255, 99, 132, 1)',
            borderWidth: 2
        }]
    };

    const ctx5 = document.getElementById('transactionHistoryChart').getContext('2d');
    new Chart(ctx5, {
        type: 'bar',
        data: transactionHistoryData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Users with Active Wallet Balances Chart
    const usersWithActiveWalletsData = {
        labels: ['Users with Active Wallets'],
        datasets: [{
            label: 'Users with Active Wallets',
            data: [{{ $usersWithActiveWallets }}],
            backgroundColor: 'rgba(153, 102, 255, 0.2)',
            borderColor: 'rgba(153, 102, 255, 1)',
            borderWidth: 2
        }]
    };

    const ctx6 = document.getElementById('usersWithActiveWalletsChart').getContext('2d');
    new Chart(ctx6, {
        type: 'bar',
        data: usersWithActiveWalletsData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
@endsection

@endsection
