@extends('layouts.admin')

@section('title', 'MT5 Connection Settings')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4">MT5 Connection Settings</h2>

    <!-- Display Success and Error Messages -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Real Server Settings -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Real Server Settings</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.mt5.settings.update') }}" method="POST">
                @csrf
                <input type="hidden" name="server_type" value="real">

                <div class="mb-3">
                    <label for="real_server" class="form-label">Server</label>
                    <input type="text" id="real_server" name="server" 
                           class="form-control @error('server') is-invalid @enderror" 
                           value="{{ old('server', $realSettings->server ?? '') }}" required>
                    @error('server')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="real_port" class="form-label">Port</label>
                    <input type="number" id="real_port" name="port" 
                           class="form-control @error('port') is-invalid @enderror" 
                           value="{{ old('port', $realSettings->port ?? 443) }}" required>
                    @error('port')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="real_manager_login" class="form-label">Manager Login</label>
                    <input type="text" id="real_manager_login" name="manager_login" 
                           class="form-control @error('manager_login') is-invalid @enderror" 
                           value="{{ old('manager_login', $realSettings->manager_login ?? '') }}" required>
                    @error('manager_login')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="real_manager_password" class="form-label">Manager Password</label>
                    <input type="password" id="real_manager_password" name="manager_password" 
                           class="form-control @error('manager_password') is-invalid @enderror" 
                           value="{{ old('manager_password', $realSettings->manager_password ?? '') }}" required>
                    @error('manager_password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary">Save Real Settings</button>
            </form>
        </div>
    </div>

    <!-- Demo Server Settings -->
    <div class="card">
        <div class="card-header">
            <h5>Demo Server Settings</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.mt5.settings.update') }}" method="POST">
                @csrf
                <input type="hidden" name="server_type" value="demo">

                <div class="mb-3">
                    <label for="demo_server" class="form-label">Server</label>
                    <input type="text" id="demo_server" name="server" 
                           class="form-control @error('server') is-invalid @enderror" 
                           value="{{ old('server', $demoSettings->server ?? '') }}" required>
                    @error('server')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="demo_port" class="form-label">Port</label>
                    <input type="number" id="demo_port" name="port" 
                           class="form-control @error('port') is-invalid @enderror" 
                           value="{{ old('port', $demoSettings->port ?? 443) }}" required>
                    @error('port')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="demo_manager_login" class="form-label">Manager Login</label>
                    <input type="text" id="demo_manager_login" name="manager_login" 
                           class="form-control @error('manager_login') is-invalid @enderror" 
                           value="{{ old('manager_login', $demoSettings->manager_login ?? '') }}" required>
                    @error('manager_login')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="demo_manager_password" class="form-label">Manager Password</label>
                    <input type="password" id="demo_manager_password" name="manager_password" 
                           class="form-control @error('manager_password') is-invalid @enderror" 
                           value="{{ old('manager_password', $demoSettings->manager_password ?? '') }}" required>
                    @error('manager_password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary">Save Demo Settings</button>
            </form>
        </div>
    </div>
</div>
@endsection
