@extends('layouts.admin')

@section('title', 'Create MT5 Account')

@section('content')
<div class="container mt-4">
    <h2>Create MT5 Account</h2>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <form action="{{ route('admin.mt5.createAccount') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" id="name" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="group" class="form-label">Group</label>
            <input type="text" id="group" name="group" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="leverage" class="form-label">Leverage</label>
            <input type="number" id="leverage" name="leverage" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="main_password" class="form-label">Main Password</label>
            <input type="password" id="main_password" name="main_password" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="investor_password" class="form-label">Investor Password</label>
            <input type="password" id="investor_password" name="investor_password" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="phone_password" class="form-label">Phone Password</label>
            <input type="password" id="phone_password" name="phone_password" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Create Account</button>
    </form>
</div>
@endsection
