@extends('layouts.admin')

@section('title', 'KYC Management')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4 text-center text-primary">
        <i class="fas fa-id-card me-2"></i> KYC Documents Management
    </h2>

    <!-- Search and Filter Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex">
            <form action="{{ route('admin.kyc.index') }}" method="GET" class="d-inline-flex">
                <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Search by User Name or Email" value="{{ request('search') }}">
                <select name="status" class="form-select form-select-sm me-2" onchange="this.form.submit()">
                    <option value="">All Statuses</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>Approved</option>
                    <option value="rejected" {{ request('status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                </select>
                <button type="submit" class="btn btn-sm btn-light"><i class="fas fa-filter"></i> Filter</button>
            </form>
        </div>

        <!-- Bulk Actions -->
        <div>
            <button class="btn btn-sm btn-danger me-2" id="bulkRejectBtn" disabled><i class="fas fa-times-circle"></i> Reject Selected</button>
            <button class="btn btn-sm btn-success me-2" id="bulkApproveBtn" disabled><i class="fas fa-check-circle"></i> Approve Selected</button>
            <button class="btn btn-sm btn-secondary" id="exportCsvBtn"><i class="fas fa-download"></i> Export CSV</button>
        </div>
    </div>

    <!-- KYC Document Table -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
            <span><i class="fas fa-file-alt me-2"></i> KYC Submissions</span>
        </div>
        <div class="card-body">
            @if($kycDocuments->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No KYC documents found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle">
                        <thead class="table-primary text-center">
                            <tr>
                                <th><input type="checkbox" id="selectAll"></th>
                                <th>User</th>
                                <th>Status</th>
                                <th>Submitted At</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($kycDocuments as $kyc)
                                <tr class="text-center">
                                    <td><input type="checkbox" class="kyc-checkbox" data-id="{{ $kyc->id }}"></td>
                                    <td>
                                        <strong>{{ $kyc->user->name }}</strong> <br>
                                        <small class="text-muted">{{ $kyc->user->email }}</small>
                                    </td>
                                    <td>
                                        <span class="badge rounded-pill bg-{{ $kyc->status === 'approved' ? 'success' : ($kyc->status === 'rejected' ? 'danger' : 'warning') }}">
                                            {{ ucfirst($kyc->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $kyc->created_at->format('d M, Y H:i') }}</td>
                                    <td>{{ $kyc->updated_at->diffForHumans() }}</td>
                                    <td class="text-center">
                                        <a href="{{ route('admin.kyc.show', $kyc->id) }}" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="View Details">
                                            <i class="fas fa-eye me-1"></i> View
                                        </a>
                                        @if($kyc->status === 'pending')
                                            <form action="{{ route('admin.kyc.approve', $kyc->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-sm btn-success" data-bs-toggle="tooltip" title="Approve KYC">
                                                    <i class="fas fa-check me-1"></i> Approve
                                                </button>
                                            </form>
                                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $kyc->id }}" data-bs-toggle="tooltip" title="Reject KYC">
                                                <i class="fas fa-times me-1"></i> Reject
                                            </button>
                                            <!-- Reject Modal -->
                                            <div class="modal fade" id="rejectModal{{ $kyc->id }}" tabindex="-1" aria-labelledby="rejectModalLabel{{ $kyc->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="rejectModalLabel{{ $kyc->id }}">Reject KYC</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form action="{{ route('admin.kyc.reject', $kyc->id) }}" method="POST">
                                                                @csrf
                                                                <div class="mb-3">
                                                                    <label for="admin_remark" class="form-label">Reason for Rejection</label>
                                                                    <textarea name="admin_remark" id="admin_remark" class="form-control" rows="3" required></textarea>
                                                                </div>
                                                                <div class="d-flex justify-content-end">
                                                                    <button type="submit" class="btn btn-danger">Reject</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center mt-3">
                    {{ $kycDocuments->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Custom Tooltip Initialization -->
@section('scripts')
<script>
    // Enable tooltips
    document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach((tooltipElement) => {
        new bootstrap.Tooltip(tooltipElement);
    });

    // Select/Deselect all checkboxes
    document.getElementById('selectAll').addEventListener('change', function () {
        let checkboxes = document.querySelectorAll('.kyc-checkbox');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
        toggleBulkActions();
    });

    // Enable/Disable bulk action buttons based on selected checkboxes
    document.querySelectorAll('.kyc-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', toggleBulkActions);
    });

    function toggleBulkActions() {
        let selectedCheckboxes = document.querySelectorAll('.kyc-checkbox:checked');
        document.getElementById('bulkApproveBtn').disabled = selectedCheckboxes.length === 0;
        document.getElementById('bulkRejectBtn').disabled = selectedCheckboxes.length === 0;
    }

    // Export KYC data to CSV
    document.getElementById('exportCsvBtn').addEventListener('click', function () {
        window.location.href = "{{ route('admin.kyc.exportCsv') }}";
    });
</script>
@endsection

@endsection
