@extends('layouts.admin')

@section('title', 'IB User Report')

@section('content')
<div class="container-fluid py-4">
    <h2 class="text-primary fw-bold text-center mb-4">
        <i class="fas fa-user-chart me-2"></i> IB User Report
    </h2>

    <!-- Total Earnings -->
    <div class="card my-4 shadow">
        <div class="card-body text-center">
            <h4>Total Earnings</h4>
            <h2 class="text-success">${{ number_format($totalEarnings, 2) }}</h2>
        </div>
    </div>

    <!-- Referrals Table -->
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-primary text-white rounded-top">
            <strong><i class="fas fa-users me-2"></i> Referrals</strong>
        </div>
        <div class="card-body">
            @if ($referrals->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No referrals found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Referred Name</th>
                                <th>Referred Email</th>
                                <th>Earnings</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($referrals as $referral)
                                <tr class="text-center">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $referral->referredUser->name }}</td>
                                    <td>{{ $referral->referredUser->email }}</td>
                                    <td>${{ number_format($referral->earnings, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center mt-4">
                    {{ $referrals->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
