@extends('layouts.admin')

@section('title', 'IB Reports')

@section('content')
<div class="container-fluid py-4">
    <h2 class="text-primary fw-bold text-center mb-4">
        <i class="fas fa-file-alt me-2"></i> IB Reports
    </h2>

    <!-- Withdrawals Overview -->
    <div class="row g-4 mb-4">
        <div class="col-lg-3 col-md-6">
            <div class="card bg-gradient-primary text-white shadow-sm">
                <div class="card-body text-center">
                    <h5>Total Pending Withdrawals</h5>
                    <h3>{{ $withdrawals->where('status', 'pending')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card bg-gradient-success text-white shadow-sm">
                <div class="card-body text-center">
                    <h5>Total Approved Withdrawals</h5>
                    <h3>{{ $withdrawals->where('status', 'approved')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card bg-gradient-danger text-white shadow-sm">
                <div class="card-body text-center">
                    <h5>Total Rejected Withdrawals</h5>
                    <h3>{{ $withdrawals->where('status', 'rejected')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card bg-gradient-warning text-dark shadow-sm">
                <div class="card-body text-center">
                    <h5>Total Withdrawals</h5>
                    <h3>{{ $withdrawals->count() }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Withdrawals Table -->
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-money-bill-wave me-2"></i> Commission Withdrawals</strong>
        </div>
        <div class="card-body p-4">
            @if ($withdrawals->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No withdrawal requests found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr class="text-center">
                                <th>#</th>
                                <th>User Name</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date Requested</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($withdrawals as $withdrawal)
                                <tr class="text-center">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $withdrawal->user->name }}</td>
                                    <td>${{ number_format($withdrawal->amount, 2) }}</td>
                                    <td>
                                        <span class="badge 
                                            {{ $withdrawal->status === 'pending' ? 'bg-warning text-dark' : '' }}
                                            {{ $withdrawal->status === 'approved' ? 'bg-success' : '' }}
                                            {{ $withdrawal->status === 'rejected' ? 'bg-danger' : '' }}
                                        ">
                                            {{ ucfirst($withdrawal->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $withdrawal->created_at->format('d M Y') }}</td>
                                    <td>
                                        @if ($withdrawal->status === 'pending')
                                            <form action="{{ route('admin.ib-reports.approve', $withdrawal->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <button class="btn btn-success btn-sm">
                                                    <i class="fas fa-check"></i> Approve
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.ib-reports.reject', $withdrawal->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                <input type="hidden" name="remarks" value="Rejected by admin">
                                                <button class="btn btn-danger btn-sm">
                                                    <i class="fas fa-times"></i> Reject
                                                </button>
                                            </form>
                                        @else
                                            <span class="text-muted">No Actions</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center mt-4">
                    {{ $withdrawals->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
