@extends('layouts.admin')

@section('title', 'IB Management')

@section('content')
<div class="container-fluid px-4">
    <div class="row align-items-center mb-4">
        <div class="col-12">
            <h2 class="mt-4 text-primary text-center">
                <i class="fas fa-sitemap me-2"></i> IB Management
            </h2>
        </div>
    </div>

    <!-- Filters and Search Section -->
    <div class="card mb-4 shadow-lg border-0 rounded">
        <div class="card-body">
            <form action="{{ route('admin.ib.management') }}" method="GET" class="row g-3 align-items-center">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm shadow-sm" placeholder="Search IB by name or email" value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm shadow-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm shadow-sm w-100"><i class="fas fa-filter"></i> Filter</button>
                </div>
                <div class="col-md-3 text-end">
                    <a href="{{ route('admin.ib.create') }}" class="btn btn-success btn-sm shadow-sm">
                        <i class="fas fa-plus-circle"></i> Add New IB
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- IB Management Table Section -->
    <div class="card shadow-lg border-0 rounded">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-users me-2"></i> IB List</strong>
        </div>
        <div class="card-body">
            @if($ibs->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No IBs found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0 border-0 rounded">
                        <thead class="table-primary text-center rounded-top">
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Status</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="border-top bg-light">
                            @foreach($ibs as $ib)
                                <tr class="text-center">
                                    <td>{{ $ib->id }}</td>
                                    <td class="text-truncate" style="max-width: 200px;">{{ $ib->name }}</td>
                                    <td class="text-truncate" style="max-width: 200px;">{{ $ib->email }}</td>
                                    <td>
                                        <span class="badge bg-{{ $ib->is_active ? 'success' : 'danger' }} shadow-sm" id="statusBadge{{ $ib->id }}">
                                            {{ $ib->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                        <!-- Toggle Switch for Active Status -->
                                        <div class="form-check form-switch d-inline ms-2">
                                            <input type="checkbox" class="form-check-input toggle-status shadow-sm" data-ib-id="{{ $ib->id }}" id="isActiveToggle{{ $ib->id }}" {{ $ib->is_active ? 'checked' : '' }}>
                                            <label class="form-check-label" for="isActiveToggle{{ $ib->id }}"></label>
                                        </div>
                                    </td>
                                    <td>{{ $ib->created_at->format('d M, Y H:i') }}</td>
                                    <td>
                                        <!-- View Tree Button -->
                                        <a href="{{ route('admin.ib.tree', $ib->id) }}" class="btn btn-sm btn-info shadow-sm">
                                            <i class="fas fa-sitemap"></i> View Tree
                                        </a>

                                      <!-- Edit Button -->
                                            <a href="{{ route('admin.ib.edit', $ib->id) }}" class="btn btn-sm btn-warning shadow-sm me-2">
                                                <i class="fas fa-edit"></i> Edit
                                            </a>

                                        <!-- Delete Button -->
                                        <form action="{{ route('admin.ib.delete', $ib->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger shadow-sm" onclick="return confirm('Are you sure you want to delete this IB?')">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $ibs->onEachSide(1)->links('pagination::bootstrap-5') }}
                </div>
            @endif
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // JavaScript for toggling the IB active status
        document.querySelectorAll('.toggle-status').forEach(toggle => {
            toggle.addEventListener('change', function () {
                const ibId = this.getAttribute('data-ib-id');
                const isActive = this.checked ? 1 : 0;
                const statusBadge = document.getElementById('statusBadge' + ibId);

                // Update the label for the active status
                statusBadge.className = 'badge bg-' + (isActive ? 'success' : 'danger') + ' shadow-sm';
                statusBadge.textContent = isActive ? 'Active' : 'Inactive';

                // Send AJAX request to update IB status
                fetch(`/admin/ib/${ibId}/toggle-status`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ is_active: isActive })
                }).then(response => {
                    if (!response.ok) {
                        alert('Failed to update IB status.');
                    }
                }).catch(error => {
                    alert('An error occurred: ' + error);
                });
            });
        });
    });
</script>
@endsection
