@extends('layouts.admin')

@section('title', 'Manage IB Commission Levels')

@section('content')
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary text-center fw-bold">
        <i class="fas fa-percent me-2"></i> Manage IB Commission Levels
    </h2>

    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-list me-2"></i> Commission Levels</strong>
            <a href="{{ route('admin.ib-commission-levels.create') }}" class="btn btn-light btn-sm shadow-sm rounded-pill">
                <i class="fas fa-plus-circle me-2"></i> Add New Level
            </a>
        </div>
        <div class="card-body bg-light">
            @if($commissionLevels->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No commission levels found.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle text-center">
                        <thead class="table-primary">
                            <tr>
                                <th>Level</th>
                                <th>Commission Percentage (%)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($commissionLevels as $level)
                                <tr>
                                    <td>{{ $level->level }}</td>
                                    <td>{{ $level->commission_percentage }}%</td>
                                    <td>
                                        <a href="{{ route('admin.ib-commission-levels.edit', $level->id) }}" class="btn btn-warning btn-sm shadow-sm rounded-pill">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        <form action="{{ route('admin.ib-commission-levels.destroy', $level->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this level?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm shadow-sm rounded-pill">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
