@extends('layouts.admin')

@section('content')
<div class="container-fluid px-4">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="text-primary fw-bold">Admin Dashboard</h1>
    </div>

    <!-- Summary Cards Section -->
    <div class="row mb-4">
        <!-- Cards for displaying summary data -->
        @php
            $cardData = [
                ['title' => 'Total Users', 'value' => $totalUsers, 'icon' => 'fas fa-users', 'gradient' => 'linear-gradient(135deg, #6a11cb, #2575fc)'],
                ['title' => 'Active Trades', 'value' => $activeTrades, 'icon' => 'fas fa-chart-line', 'gradient' => 'linear-gradient(135deg, #56ab2f, #a8e063)'],
                ['title' => 'Total Wallet Balance', 'value' => '$' . number_format($walletBalance, 2), 'icon' => 'fas fa-wallet', 'gradient' => 'linear-gradient(135deg, #f7971e, #ffd200)'],
                ['title' => 'New Signups (Last 7 Days)', 'value' => $newSignups, 'icon' => 'fas fa-user-plus', 'gradient' => 'linear-gradient(135deg, #1e3c72, #2a5298)'],
                ['title' => 'Total Deposits', 'value' => '$' . number_format($totalDeposits, 2), 'icon' => 'fas fa-arrow-circle-down', 'gradient' => 'linear-gradient(135deg, #6c5ce7, #8e44ad)'],
                ['title' => 'Total Withdrawals', 'value' => '$' . number_format($totalWithdrawals, 2), 'icon' => 'fas fa-arrow-circle-up', 'gradient' => 'linear-gradient(135deg, #fd79a8, #ff4757)'],
                ['title' => 'Active Trading Accounts', 'value' => $activeTradingAccounts, 'icon' => 'fas fa-user-cog', 'gradient' => 'linear-gradient(135deg, #00b894, #2ecc71)'],
                ['title' => 'Total Trades', 'value' => $totalTrades, 'icon' => 'fas fa-exchange-alt', 'gradient' => 'linear-gradient(135deg, #3b6978, #204051)'],
            ];
        @endphp

        @foreach ($cardData as $card)
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-sm border-0" style="height: 100%; background: {{ $card['gradient'] }}; color: white;">
                    <div class="card-body d-flex flex-column justify-content-between">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h5 class="card-title">{{ $card['title'] }}</h5>
                                <h2 class="fw-bold">{{ $card['value'] }}</h2>
                            </div>
                            <div>
                                <i class="{{ $card['icon'] }} fa-3x text-white-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Charts Section -->
    <div class="row mb-4">
        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-chart-bar me-2"></i> Trade Performance (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="tradesPerDayChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-user-plus me-2"></i> User Signups (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="userSignupsChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-history me-2"></i> Transaction History (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="transactionHistoryChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-header" style="background: #212529; color: white;">
                    <i class="fas fa-chart-pie me-2"></i> Deposit vs Withdrawals (Last 30 Days)
                </div>
                <div class="card-body">
                    <canvas id="depositWithdrawalChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Transactions Section -->
    <div class="card shadow border-0 mb-4">
        <div class="card-header" style="background: #212529; color: white;">
            <i class="fas fa-history me-2"></i> Recent Transactions
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($recentTransactions as $transaction)
                            <tr>
                                <td>{{ $transaction->id }}</td>
                                <td>{{ $transaction->user->name }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->type === 'deposit' ? 'success' : 'warning' }}">
                                        {{ ucfirst($transaction->type) }}
                                    </span>
                                </td>
                                <td>${{ number_format($transaction->amount, 2) }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->status === 'approved' ? 'success' : ($transaction->status === 'pending' ? 'warning' : 'danger') }}">
                                        {{ ucfirst($transaction->status) }}
                                    </span>
                                </td>
                                <td>{{ $transaction->created_at->format('d M Y, h:i A') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Data for Trades per Day Chart
    const tradesPerDayData = {
        labels: @json(array_keys($tradesPerDay->toArray())),
        datasets: [{
            label: 'Trades Per Day',
            data: @json(array_values($tradesPerDay->toArray())),
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            borderColor: 'rgba(54, 162, 235, 1)',
            borderWidth: 2,
            fill: true
        }]
    };

    // Trades Per Day Chart
    const ctx1 = document.getElementById('tradesPerDayChart').getContext('2d');
    new Chart(ctx1, {
        type: 'line',
        data: tradesPerDayData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Data for User Signups Chart
    const userSignupsData = {
        labels: @json(array_keys($userSignups->toArray())),
        datasets: [{
            label: 'User Signups',
            data: @json(array_values($userSignups->toArray())),
            backgroundColor: 'rgba(153, 102, 255, 0.2)',
            borderColor: 'rgba(153, 102, 255, 1)',
            borderWidth: 2,
            fill: true
        }]
    };

    // User Signups Chart
    const ctx2 = document.getElementById('userSignupsChart').getContext('2d');
    new Chart(ctx2, {
        type: 'line',
        data: userSignupsData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Data for Transaction History Chart
    const transactionHistoryData = {
        labels: @json(array_keys($transactionHistory->toArray())),
        datasets: [{
            label: 'Transactions (Deposit / Withdrawal)',
            data: @json(array_values($transactionHistory->toArray())),
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor: 'rgba(255, 99, 132, 1)',
            borderWidth: 2,
            fill: true
        }]
    };

    // Transaction History Chart
    const ctx3 = document.getElementById('transactionHistoryChart').getContext('2d');
    new Chart(ctx3, {
        type: 'bar',
        data: transactionHistoryData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Data for Deposit vs Withdrawal Chart
    const depositWithdrawalData = {
        labels: ['Deposits', 'Withdrawals'],
        datasets: [{
            label: 'Total Amount',
            data: [{{ $totalDeposits }}, {{ $totalWithdrawals }}],
            backgroundColor: [
                'rgba(75, 192, 192, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(75, 192, 192, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 2
        }]
    };

    // Deposit vs Withdrawal Chart
    const ctx4 = document.getElementById('depositWithdrawalChart').getContext('2d');
    new Chart(ctx4, {
        type: 'pie',
        data: depositWithdrawalData,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
</script>
@endsection

@endsection
